// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutContactpointParams creates a new PutContactpointParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutContactpointParams() *PutContactpointParams {
	return &PutContactpointParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutContactpointParamsWithTimeout creates a new PutContactpointParams object
// with the ability to set a timeout on a request.
func NewPutContactpointParamsWithTimeout(timeout time.Duration) *PutContactpointParams {
	return &PutContactpointParams{
		timeout: timeout,
	}
}

// NewPutContactpointParamsWithContext creates a new PutContactpointParams object
// with the ability to set a context for a request.
func NewPutContactpointParamsWithContext(ctx context.Context) *PutContactpointParams {
	return &PutContactpointParams{
		Context: ctx,
	}
}

// NewPutContactpointParamsWithHTTPClient creates a new PutContactpointParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutContactpointParamsWithHTTPClient(client *http.Client) *PutContactpointParams {
	return &PutContactpointParams{
		HTTPClient: client,
	}
}

/*
PutContactpointParams contains all the parameters to send to the API endpoint

	for the put contactpoint operation.

	Typically these are written to a http.Request.
*/
type PutContactpointParams struct {

	// Body.
	Body *models.EmbeddedContactPoint

	/* UID.

	   UID is the contact point unique identifier
	*/
	UID string

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put contactpoint params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutContactpointParams) WithDefaults() *PutContactpointParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put contactpoint params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutContactpointParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put contactpoint params
func (o *PutContactpointParams) WithTimeout(timeout time.Duration) *PutContactpointParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put contactpoint params
func (o *PutContactpointParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put contactpoint params
func (o *PutContactpointParams) WithContext(ctx context.Context) *PutContactpointParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put contactpoint params
func (o *PutContactpointParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put contactpoint params
func (o *PutContactpointParams) WithHTTPClient(client *http.Client) *PutContactpointParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put contactpoint params
func (o *PutContactpointParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put contactpoint params
func (o *PutContactpointParams) WithBody(body *models.EmbeddedContactPoint) *PutContactpointParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put contactpoint params
func (o *PutContactpointParams) SetBody(body *models.EmbeddedContactPoint) {
	o.Body = body
}

// WithUID adds the uid to the put contactpoint params
func (o *PutContactpointParams) WithUID(uid string) *PutContactpointParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the put contactpoint params
func (o *PutContactpointParams) SetUID(uid string) {
	o.UID = uid
}

// WithXDisableProvenance adds the xDisableProvenance to the put contactpoint params
func (o *PutContactpointParams) WithXDisableProvenance(xDisableProvenance *string) *PutContactpointParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put contactpoint params
func (o *PutContactpointParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PutContactpointParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param UID
	if err := r.SetPathParam("UID", o.UID); err != nil {
		return err
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
