// Code generated by go-swagger; DO NOT EDIT.

package query_history

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteQueryReader is a Reader for the DeleteQuery structure.
type DeleteQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteQueryUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteQueryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /query-history/{query_history_uid}] deleteQuery", response, response.Code())
	}
}

// NewDeleteQueryOK creates a DeleteQueryOK with default headers values
func NewDeleteQueryOK() *DeleteQueryOK {
	return &DeleteQueryOK{}
}

/*
DeleteQueryOK describes a response with status code 200, with default header values.

(empty)
*/
type DeleteQueryOK struct {
	Payload *models.QueryHistoryDeleteQueryResponse
}

// IsSuccess returns true when this delete query Ok response has a 2xx status code
func (o *DeleteQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete query Ok response has a 3xx status code
func (o *DeleteQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete query Ok response has a 4xx status code
func (o *DeleteQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete query Ok response has a 5xx status code
func (o *DeleteQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete query Ok response a status code equal to that given
func (o *DeleteQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete query Ok response
func (o *DeleteQueryOK) Code() int {
	return 200
}

func (o *DeleteQueryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryOk %s", 200, payload)
}

func (o *DeleteQueryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryOk %s", 200, payload)
}

func (o *DeleteQueryOK) GetPayload() *models.QueryHistoryDeleteQueryResponse {
	return o.Payload
}

func (o *DeleteQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QueryHistoryDeleteQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteQueryUnauthorized creates a DeleteQueryUnauthorized with default headers values
func NewDeleteQueryUnauthorized() *DeleteQueryUnauthorized {
	return &DeleteQueryUnauthorized{}
}

/*
DeleteQueryUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteQueryUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete query unauthorized response has a 2xx status code
func (o *DeleteQueryUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete query unauthorized response has a 3xx status code
func (o *DeleteQueryUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete query unauthorized response has a 4xx status code
func (o *DeleteQueryUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete query unauthorized response has a 5xx status code
func (o *DeleteQueryUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete query unauthorized response a status code equal to that given
func (o *DeleteQueryUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete query unauthorized response
func (o *DeleteQueryUnauthorized) Code() int {
	return 401
}

func (o *DeleteQueryUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryUnauthorized %s", 401, payload)
}

func (o *DeleteQueryUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryUnauthorized %s", 401, payload)
}

func (o *DeleteQueryUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteQueryUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteQueryInternalServerError creates a DeleteQueryInternalServerError with default headers values
func NewDeleteQueryInternalServerError() *DeleteQueryInternalServerError {
	return &DeleteQueryInternalServerError{}
}

/*
DeleteQueryInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteQueryInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete query internal server error response has a 2xx status code
func (o *DeleteQueryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete query internal server error response has a 3xx status code
func (o *DeleteQueryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete query internal server error response has a 4xx status code
func (o *DeleteQueryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete query internal server error response has a 5xx status code
func (o *DeleteQueryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete query internal server error response a status code equal to that given
func (o *DeleteQueryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete query internal server error response
func (o *DeleteQueryInternalServerError) Code() int {
	return 500
}

func (o *DeleteQueryInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryInternalServerError %s", 500, payload)
}

func (o *DeleteQueryInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/{query_history_uid}][%d] deleteQueryInternalServerError %s", 500, payload)
}

func (o *DeleteQueryInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteQueryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
