// Code generated by go-swagger; DO NOT EDIT.

package saml

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetSAMLLogoutReader is a Reader for the GetSAMLLogout structure.
type GetSAMLLogoutReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSAMLLogoutReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 302:
		result := NewGetSAMLLogoutFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetSAMLLogoutNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSAMLLogoutInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /logout/saml] getSAMLLogout", response, response.Code())
	}
}

// NewGetSAMLLogoutFound creates a GetSAMLLogoutFound with default headers values
func NewGetSAMLLogoutFound() *GetSAMLLogoutFound {
	return &GetSAMLLogoutFound{}
}

/*
GetSAMLLogoutFound describes a response with status code 302, with default header values.

(empty)
*/
type GetSAMLLogoutFound struct {
}

// IsSuccess returns true when this get s a m l logout found response has a 2xx status code
func (o *GetSAMLLogoutFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get s a m l logout found response has a 3xx status code
func (o *GetSAMLLogoutFound) IsRedirect() bool {
	return true
}

// IsClientError returns true when this get s a m l logout found response has a 4xx status code
func (o *GetSAMLLogoutFound) IsClientError() bool {
	return false
}

// IsServerError returns true when this get s a m l logout found response has a 5xx status code
func (o *GetSAMLLogoutFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get s a m l logout found response a status code equal to that given
func (o *GetSAMLLogoutFound) IsCode(code int) bool {
	return code == 302
}

// Code gets the status code for the get s a m l logout found response
func (o *GetSAMLLogoutFound) Code() int {
	return 302
}

func (o *GetSAMLLogoutFound) Error() string {
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutFound", 302)
}

func (o *GetSAMLLogoutFound) String() string {
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutFound", 302)
}

func (o *GetSAMLLogoutFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetSAMLLogoutNotFound creates a GetSAMLLogoutNotFound with default headers values
func NewGetSAMLLogoutNotFound() *GetSAMLLogoutNotFound {
	return &GetSAMLLogoutNotFound{}
}

/*
GetSAMLLogoutNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetSAMLLogoutNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get s a m l logout not found response has a 2xx status code
func (o *GetSAMLLogoutNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get s a m l logout not found response has a 3xx status code
func (o *GetSAMLLogoutNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get s a m l logout not found response has a 4xx status code
func (o *GetSAMLLogoutNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get s a m l logout not found response has a 5xx status code
func (o *GetSAMLLogoutNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get s a m l logout not found response a status code equal to that given
func (o *GetSAMLLogoutNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get s a m l logout not found response
func (o *GetSAMLLogoutNotFound) Code() int {
	return 404
}

func (o *GetSAMLLogoutNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutNotFound %s", 404, payload)
}

func (o *GetSAMLLogoutNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutNotFound %s", 404, payload)
}

func (o *GetSAMLLogoutNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSAMLLogoutNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSAMLLogoutInternalServerError creates a GetSAMLLogoutInternalServerError with default headers values
func NewGetSAMLLogoutInternalServerError() *GetSAMLLogoutInternalServerError {
	return &GetSAMLLogoutInternalServerError{}
}

/*
GetSAMLLogoutInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetSAMLLogoutInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get s a m l logout internal server error response has a 2xx status code
func (o *GetSAMLLogoutInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get s a m l logout internal server error response has a 3xx status code
func (o *GetSAMLLogoutInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get s a m l logout internal server error response has a 4xx status code
func (o *GetSAMLLogoutInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get s a m l logout internal server error response has a 5xx status code
func (o *GetSAMLLogoutInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get s a m l logout internal server error response a status code equal to that given
func (o *GetSAMLLogoutInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get s a m l logout internal server error response
func (o *GetSAMLLogoutInternalServerError) Code() int {
	return 500
}

func (o *GetSAMLLogoutInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutInternalServerError %s", 500, payload)
}

func (o *GetSAMLLogoutInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /logout/saml][%d] getSAMLLogoutInternalServerError %s", 500, payload)
}

func (o *GetSAMLLogoutInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSAMLLogoutInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
