// Code generated by go-swagger; DO NOT EDIT.

package snapshots

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDashboardSnapshotReader is a Reader for the GetDashboardSnapshot structure.
type GetDashboardSnapshotReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDashboardSnapshotReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDashboardSnapshotOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetDashboardSnapshotBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetDashboardSnapshotNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDashboardSnapshotInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /snapshots/{key}] getDashboardSnapshot", response, response.Code())
	}
}

// NewGetDashboardSnapshotOK creates a GetDashboardSnapshotOK with default headers values
func NewGetDashboardSnapshotOK() *GetDashboardSnapshotOK {
	return &GetDashboardSnapshotOK{}
}

/*
GetDashboardSnapshotOK describes a response with status code 200, with default header values.

(empty)
*/
type GetDashboardSnapshotOK struct {
}

// IsSuccess returns true when this get dashboard snapshot Ok response has a 2xx status code
func (o *GetDashboardSnapshotOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get dashboard snapshot Ok response has a 3xx status code
func (o *GetDashboardSnapshotOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard snapshot Ok response has a 4xx status code
func (o *GetDashboardSnapshotOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get dashboard snapshot Ok response has a 5xx status code
func (o *GetDashboardSnapshotOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard snapshot Ok response a status code equal to that given
func (o *GetDashboardSnapshotOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get dashboard snapshot Ok response
func (o *GetDashboardSnapshotOK) Code() int {
	return 200
}

func (o *GetDashboardSnapshotOK) Error() string {
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotOk", 200)
}

func (o *GetDashboardSnapshotOK) String() string {
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotOk", 200)
}

func (o *GetDashboardSnapshotOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetDashboardSnapshotBadRequest creates a GetDashboardSnapshotBadRequest with default headers values
func NewGetDashboardSnapshotBadRequest() *GetDashboardSnapshotBadRequest {
	return &GetDashboardSnapshotBadRequest{}
}

/*
GetDashboardSnapshotBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetDashboardSnapshotBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard snapshot bad request response has a 2xx status code
func (o *GetDashboardSnapshotBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard snapshot bad request response has a 3xx status code
func (o *GetDashboardSnapshotBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard snapshot bad request response has a 4xx status code
func (o *GetDashboardSnapshotBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get dashboard snapshot bad request response has a 5xx status code
func (o *GetDashboardSnapshotBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard snapshot bad request response a status code equal to that given
func (o *GetDashboardSnapshotBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get dashboard snapshot bad request response
func (o *GetDashboardSnapshotBadRequest) Code() int {
	return 400
}

func (o *GetDashboardSnapshotBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotBadRequest %s", 400, payload)
}

func (o *GetDashboardSnapshotBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotBadRequest %s", 400, payload)
}

func (o *GetDashboardSnapshotBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardSnapshotBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardSnapshotNotFound creates a GetDashboardSnapshotNotFound with default headers values
func NewGetDashboardSnapshotNotFound() *GetDashboardSnapshotNotFound {
	return &GetDashboardSnapshotNotFound{}
}

/*
GetDashboardSnapshotNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetDashboardSnapshotNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard snapshot not found response has a 2xx status code
func (o *GetDashboardSnapshotNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard snapshot not found response has a 3xx status code
func (o *GetDashboardSnapshotNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard snapshot not found response has a 4xx status code
func (o *GetDashboardSnapshotNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get dashboard snapshot not found response has a 5xx status code
func (o *GetDashboardSnapshotNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard snapshot not found response a status code equal to that given
func (o *GetDashboardSnapshotNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get dashboard snapshot not found response
func (o *GetDashboardSnapshotNotFound) Code() int {
	return 404
}

func (o *GetDashboardSnapshotNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotNotFound %s", 404, payload)
}

func (o *GetDashboardSnapshotNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotNotFound %s", 404, payload)
}

func (o *GetDashboardSnapshotNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardSnapshotNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardSnapshotInternalServerError creates a GetDashboardSnapshotInternalServerError with default headers values
func NewGetDashboardSnapshotInternalServerError() *GetDashboardSnapshotInternalServerError {
	return &GetDashboardSnapshotInternalServerError{}
}

/*
GetDashboardSnapshotInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDashboardSnapshotInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard snapshot internal server error response has a 2xx status code
func (o *GetDashboardSnapshotInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard snapshot internal server error response has a 3xx status code
func (o *GetDashboardSnapshotInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard snapshot internal server error response has a 4xx status code
func (o *GetDashboardSnapshotInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get dashboard snapshot internal server error response has a 5xx status code
func (o *GetDashboardSnapshotInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get dashboard snapshot internal server error response a status code equal to that given
func (o *GetDashboardSnapshotInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get dashboard snapshot internal server error response
func (o *GetDashboardSnapshotInternalServerError) Code() int {
	return 500
}

func (o *GetDashboardSnapshotInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotInternalServerError %s", 500, payload)
}

func (o *GetDashboardSnapshotInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapshots/{key}][%d] getDashboardSnapshotInternalServerError %s", 500, payload)
}

func (o *GetDashboardSnapshotInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardSnapshotInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
