// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateUserReader is a Reader for the UpdateUser structure.
type UpdateUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateUserUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateUserForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateUserNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewUpdateUserConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateUserInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /users/{user_id}] updateUser", response, response.Code())
	}
}

// NewUpdateUserOK creates a UpdateUserOK with default headers values
func NewUpdateUserOK() *UpdateUserOK {
	return &UpdateUserOK{}
}

/*
UpdateUserOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateUserOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update user Ok response has a 2xx status code
func (o *UpdateUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update user Ok response has a 3xx status code
func (o *UpdateUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user Ok response has a 4xx status code
func (o *UpdateUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user Ok response has a 5xx status code
func (o *UpdateUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update user Ok response a status code equal to that given
func (o *UpdateUserOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update user Ok response
func (o *UpdateUserOK) Code() int {
	return 200
}

func (o *UpdateUserOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserOk %s", 200, payload)
}

func (o *UpdateUserOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserOk %s", 200, payload)
}

func (o *UpdateUserOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserUnauthorized creates a UpdateUserUnauthorized with default headers values
func NewUpdateUserUnauthorized() *UpdateUserUnauthorized {
	return &UpdateUserUnauthorized{}
}

/*
UpdateUserUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateUserUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user unauthorized response has a 2xx status code
func (o *UpdateUserUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user unauthorized response has a 3xx status code
func (o *UpdateUserUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user unauthorized response has a 4xx status code
func (o *UpdateUserUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user unauthorized response has a 5xx status code
func (o *UpdateUserUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update user unauthorized response a status code equal to that given
func (o *UpdateUserUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update user unauthorized response
func (o *UpdateUserUnauthorized) Code() int {
	return 401
}

func (o *UpdateUserUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserUnauthorized %s", 401, payload)
}

func (o *UpdateUserUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserUnauthorized %s", 401, payload)
}

func (o *UpdateUserUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserForbidden creates a UpdateUserForbidden with default headers values
func NewUpdateUserForbidden() *UpdateUserForbidden {
	return &UpdateUserForbidden{}
}

/*
UpdateUserForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateUserForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user forbidden response has a 2xx status code
func (o *UpdateUserForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user forbidden response has a 3xx status code
func (o *UpdateUserForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user forbidden response has a 4xx status code
func (o *UpdateUserForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user forbidden response has a 5xx status code
func (o *UpdateUserForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update user forbidden response a status code equal to that given
func (o *UpdateUserForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update user forbidden response
func (o *UpdateUserForbidden) Code() int {
	return 403
}

func (o *UpdateUserForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserForbidden %s", 403, payload)
}

func (o *UpdateUserForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserForbidden %s", 403, payload)
}

func (o *UpdateUserForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserNotFound creates a UpdateUserNotFound with default headers values
func NewUpdateUserNotFound() *UpdateUserNotFound {
	return &UpdateUserNotFound{}
}

/*
UpdateUserNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateUserNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user not found response has a 2xx status code
func (o *UpdateUserNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user not found response has a 3xx status code
func (o *UpdateUserNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user not found response has a 4xx status code
func (o *UpdateUserNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user not found response has a 5xx status code
func (o *UpdateUserNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update user not found response a status code equal to that given
func (o *UpdateUserNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update user not found response
func (o *UpdateUserNotFound) Code() int {
	return 404
}

func (o *UpdateUserNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserNotFound %s", 404, payload)
}

func (o *UpdateUserNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserNotFound %s", 404, payload)
}

func (o *UpdateUserNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserConflict creates a UpdateUserConflict with default headers values
func NewUpdateUserConflict() *UpdateUserConflict {
	return &UpdateUserConflict{}
}

/*
UpdateUserConflict describes a response with status code 409, with default header values.

ConflictError
*/
type UpdateUserConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user conflict response has a 2xx status code
func (o *UpdateUserConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user conflict response has a 3xx status code
func (o *UpdateUserConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user conflict response has a 4xx status code
func (o *UpdateUserConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user conflict response has a 5xx status code
func (o *UpdateUserConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this update user conflict response a status code equal to that given
func (o *UpdateUserConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the update user conflict response
func (o *UpdateUserConflict) Code() int {
	return 409
}

func (o *UpdateUserConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserConflict %s", 409, payload)
}

func (o *UpdateUserConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserConflict %s", 409, payload)
}

func (o *UpdateUserConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserInternalServerError creates a UpdateUserInternalServerError with default headers values
func NewUpdateUserInternalServerError() *UpdateUserInternalServerError {
	return &UpdateUserInternalServerError{}
}

/*
UpdateUserInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateUserInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user internal server error response has a 2xx status code
func (o *UpdateUserInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user internal server error response has a 3xx status code
func (o *UpdateUserInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user internal server error response has a 4xx status code
func (o *UpdateUserInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user internal server error response has a 5xx status code
func (o *UpdateUserInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update user internal server error response a status code equal to that given
func (o *UpdateUserInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update user internal server error response
func (o *UpdateUserInternalServerError) Code() int {
	return 500
}

func (o *UpdateUserInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserInternalServerError %s", 500, payload)
}

func (o *UpdateUserInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /users/{user_id}][%d] updateUserInternalServerError %s", 500, payload)
}

func (o *UpdateUserInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
