// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// GettableRuleGroupConfig gettable rule group config
//
// swagger:model GettableRuleGroupConfig
type GettableRuleGroupConfig struct {

	// align evaluation time on interval
	AlignEvaluationTimeOnInterval bool `json:"align_evaluation_time_on_interval,omitempty"`

	// evaluation delay
	EvaluationDelay string `json:"evaluation_delay,omitempty"`

	// interval
	Interval Duration `json:"interval,omitempty"`

	// limit
	Limit int64 `json:"limit,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// query offset
	QueryOffset string `json:"query_offset,omitempty"`

	// rules
	Rules []*GettableExtendedRuleNode `json:"rules"`

	// source tenants
	SourceTenants []string `json:"source_tenants"`
}

// Validate validates this gettable rule group config
func (m *GettableRuleGroupConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GettableRuleGroupConfig) validateInterval(formats strfmt.Registry) error {
	if swag.IsZero(m.Interval) { // not required
		return nil
	}

	if err := m.Interval.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("interval")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("interval")
		}
		return err
	}

	return nil
}

func (m *GettableRuleGroupConfig) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this gettable rule group config based on the context it is used
func (m *GettableRuleGroupConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInterval(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GettableRuleGroupConfig) contextValidateInterval(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Interval) { // not required
		return nil
	}

	if err := m.Interval.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("interval")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("interval")
		}
		return err
	}

	return nil
}

func (m *GettableRuleGroupConfig) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {

			if swag.IsZero(m.Rules[i]) { // not required
				return nil
			}

			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *GettableRuleGroupConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GettableRuleGroupConfig) UnmarshalBinary(b []byte) error {
	var res GettableRuleGroupConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
