// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// ListAgentsRequest
type ListAgentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of agents to list.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of agents.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// ListAgentsResponse
type ListAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of agents in your account.
	Agents []AgentListEntry `type:"list"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of agents.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAgents = "ListAgents"

// ListAgentsRequest returns a request value for making API operation for
// AWS DataSync.
//
// Returns a list of agents owned by an AWS account in the AWS Region specified
// in the request. The returned list is ordered by agent Amazon Resource Name
// (ARN).
//
// By default, this operation returns a maximum of 100 agents. This operation
// supports pagination that enables you to optionally reduce the number of agents
// returned in a response.
//
// If you have more agents than are returned in a response (that is, the response
// returns only a truncated list of your agents), the response contains a marker
// that you can specify in your next request to fetch the next page of agents.
//
//    // Example sending a request using ListAgentsRequest.
//    req := client.ListAgentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents
func (c *Client) ListAgentsRequest(input *ListAgentsInput) ListAgentsRequest {
	op := &aws.Operation{
		Name:       opListAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentsInput{}
	}

	req := c.newRequest(op, input, &ListAgentsOutput{})
	return ListAgentsRequest{Request: req, Input: input, Copy: c.ListAgentsRequest}
}

// ListAgentsRequest is the request type for the
// ListAgents API operation.
type ListAgentsRequest struct {
	*aws.Request
	Input *ListAgentsInput
	Copy  func(*ListAgentsInput) ListAgentsRequest
}

// Send marshals and sends the ListAgents API request.
func (r ListAgentsRequest) Send(ctx context.Context) (*ListAgentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAgentsResponse{
		ListAgentsOutput: r.Request.Data.(*ListAgentsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAgentsRequestPaginator returns a paginator for ListAgents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAgentsRequest(input)
//   p := datasync.NewListAgentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAgentsPaginator(req ListAgentsRequest) ListAgentsPaginator {
	return ListAgentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAgentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAgentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAgentsPaginator struct {
	aws.Pager
}

func (p *ListAgentsPaginator) CurrentPage() *ListAgentsOutput {
	return p.Pager.CurrentPage().(*ListAgentsOutput)
}

// ListAgentsResponse is the response type for the
// ListAgents API operation.
type ListAgentsResponse struct {
	*ListAgentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAgents request.
func (r *ListAgentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
