// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DataSource for the evaluation. The schema of the DataSource
	// must match the schema used to create the MLModel.
	//
	// EvaluationDataSourceId is a required field
	EvaluationDataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied ID that uniquely identifies the Evaluation.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the Evaluation.
	EvaluationName *string `type:"string"`

	// The ID of the MLModel to evaluate.
	//
	// The schema used in creating the MLModel must match the schema of the DataSource
	// used in the Evaluation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEvaluationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEvaluationInput"}

	if s.EvaluationDataSourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationDataSourceId"))
	}
	if s.EvaluationDataSourceId != nil && len(*s.EvaluationDataSourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EvaluationDataSourceId", 1))
	}

	if s.EvaluationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EvaluationId", 1))
	}

	if s.MLModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a CreateEvaluation operation, and is an acknowledgement
// that Amazon ML received the request.
//
// CreateEvaluation operation is asynchronous. You can poll for status updates
// by using the GetEvcaluation operation and checking the Status parameter.
type CreateEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// The user-supplied ID that uniquely identifies the Evaluation. This value
	// should be identical to the value of the EvaluationId in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEvaluation = "CreateEvaluation"

// CreateEvaluationRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Creates a new Evaluation of an MLModel. An MLModel is evaluated on a set
// of observations associated to a DataSource. Like a DataSource for an MLModel,
// the DataSource for an Evaluation contains values for the Target Variable.
// The Evaluation compares the predicted result for each observation to the
// actual outcome and provides a summary so that you know how effective the
// MLModel functions on the test data. Evaluation generates a relevant performance
// metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on
// the corresponding MLModelType: BINARY, REGRESSION or MULTICLASS.
//
// CreateEvaluation is an asynchronous operation. In response to CreateEvaluation,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation
// status to PENDING. After the Evaluation is created and ready for use, Amazon
// ML sets the status to COMPLETED.
//
// You can use the GetEvaluation operation to check progress of the evaluation
// during the creation operation.
//
//    // Example sending a request using CreateEvaluationRequest.
//    req := client.CreateEvaluationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateEvaluationRequest(input *CreateEvaluationInput) CreateEvaluationRequest {
	op := &aws.Operation{
		Name:       opCreateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEvaluationInput{}
	}

	req := c.newRequest(op, input, &CreateEvaluationOutput{})
	return CreateEvaluationRequest{Request: req, Input: input, Copy: c.CreateEvaluationRequest}
}

// CreateEvaluationRequest is the request type for the
// CreateEvaluation API operation.
type CreateEvaluationRequest struct {
	*aws.Request
	Input *CreateEvaluationInput
	Copy  func(*CreateEvaluationInput) CreateEvaluationRequest
}

// Send marshals and sends the CreateEvaluation API request.
func (r CreateEvaluationRequest) Send(ctx context.Context) (*CreateEvaluationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEvaluationResponse{
		CreateEvaluationOutput: r.Request.Data.(*CreateEvaluationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEvaluationResponse is the response type for the
// CreateEvaluation API operation.
type CreateEvaluationResponse struct {
	*CreateEvaluationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEvaluation request.
func (r *CreateEvaluationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
