// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package smsiface provides an interface to enable mocking the AWS Server Migration Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package smsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/sms"
)

// ClientAPI provides an interface to enable mocking the
// sms.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // SMS.
//    func myFunc(svc smsiface.ClientAPI) bool {
//        // Make svc.CreateApp request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := sms.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        smsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateApp(input *sms.CreateAppInput) (*sms.CreateAppOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateAppRequest(*sms.CreateAppInput) sms.CreateAppRequest

	CreateReplicationJobRequest(*sms.CreateReplicationJobInput) sms.CreateReplicationJobRequest

	DeleteAppRequest(*sms.DeleteAppInput) sms.DeleteAppRequest

	DeleteAppLaunchConfigurationRequest(*sms.DeleteAppLaunchConfigurationInput) sms.DeleteAppLaunchConfigurationRequest

	DeleteAppReplicationConfigurationRequest(*sms.DeleteAppReplicationConfigurationInput) sms.DeleteAppReplicationConfigurationRequest

	DeleteReplicationJobRequest(*sms.DeleteReplicationJobInput) sms.DeleteReplicationJobRequest

	DeleteServerCatalogRequest(*sms.DeleteServerCatalogInput) sms.DeleteServerCatalogRequest

	DisassociateConnectorRequest(*sms.DisassociateConnectorInput) sms.DisassociateConnectorRequest

	GenerateChangeSetRequest(*sms.GenerateChangeSetInput) sms.GenerateChangeSetRequest

	GenerateTemplateRequest(*sms.GenerateTemplateInput) sms.GenerateTemplateRequest

	GetAppRequest(*sms.GetAppInput) sms.GetAppRequest

	GetAppLaunchConfigurationRequest(*sms.GetAppLaunchConfigurationInput) sms.GetAppLaunchConfigurationRequest

	GetAppReplicationConfigurationRequest(*sms.GetAppReplicationConfigurationInput) sms.GetAppReplicationConfigurationRequest

	GetConnectorsRequest(*sms.GetConnectorsInput) sms.GetConnectorsRequest

	GetReplicationJobsRequest(*sms.GetReplicationJobsInput) sms.GetReplicationJobsRequest

	GetReplicationRunsRequest(*sms.GetReplicationRunsInput) sms.GetReplicationRunsRequest

	GetServersRequest(*sms.GetServersInput) sms.GetServersRequest

	ImportServerCatalogRequest(*sms.ImportServerCatalogInput) sms.ImportServerCatalogRequest

	LaunchAppRequest(*sms.LaunchAppInput) sms.LaunchAppRequest

	ListAppsRequest(*sms.ListAppsInput) sms.ListAppsRequest

	PutAppLaunchConfigurationRequest(*sms.PutAppLaunchConfigurationInput) sms.PutAppLaunchConfigurationRequest

	PutAppReplicationConfigurationRequest(*sms.PutAppReplicationConfigurationInput) sms.PutAppReplicationConfigurationRequest

	StartAppReplicationRequest(*sms.StartAppReplicationInput) sms.StartAppReplicationRequest

	StartOnDemandReplicationRunRequest(*sms.StartOnDemandReplicationRunInput) sms.StartOnDemandReplicationRunRequest

	StopAppReplicationRequest(*sms.StopAppReplicationInput) sms.StopAppReplicationRequest

	TerminateAppRequest(*sms.TerminateAppInput) sms.TerminateAppRequest

	UpdateAppRequest(*sms.UpdateAppInput) sms.UpdateAppRequest

	UpdateReplicationJobRequest(*sms.UpdateReplicationJobInput) sms.UpdateReplicationJobRequest
}

var _ ClientAPI = (*sms.Client)(nil)
