// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RequestCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the private certificate authority (CA)
	// that will be used to issue the certificate. If you do not provide an ARN
	// and you are trying to request a private certificate, ACM will attempt to
	// issue a public certificate. For more information about private CAs, see the
	// AWS Certificate Manager Private Certificate Authority (PCA) (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html)
	// user guide. The ARN must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	CertificateAuthorityArn *string `min:"20" type:"string"`

	// Fully qualified domain name (FQDN), such as www.example.com, that you want
	// to secure with an ACM certificate. Use an asterisk (*) to create a wildcard
	// certificate that protects several sites in the same domain. For example,
	// *.example.com protects www.example.com, site.example.com, and images.example.com.
	//
	// The first domain name you enter cannot exceed 64 octets, including periods.
	// Each subsequent Subject Alternative Name (SAN), however, can be up to 253
	// octets in length.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The domain name that you want ACM to use to send you emails so that you can
	// validate domain ownership.
	DomainValidationOptions []DomainValidationOption `min:"1" type:"list"`

	// Customer chosen string that can be used to distinguish between calls to RequestCertificate.
	// Idempotency tokens time out after one hour. Therefore, if you call RequestCertificate
	// multiple times with the same idempotency token within one hour, ACM recognizes
	// that you are requesting only one certificate and will issue only one. If
	// you change the idempotency token for each call, ACM recognizes that you are
	// requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// Currently, you can use this parameter to specify whether to add the certificate
	// to a certificate transparency log. Certificate transparency makes it possible
	// to detect SSL/TLS certificates that have been mistakenly or maliciously issued.
	// Certificates that have not been logged typically produce an error message
	// in a browser. For more information, see Opting Out of Certificate Transparency
	// Logging (https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
	Options *CertificateOptions `type:"structure"`

	// Additional FQDNs to be included in the Subject Alternative Name extension
	// of the ACM certificate. For example, add the name www.example.net to a certificate
	// for which the DomainName field is www.example.com if users can reach your
	// site by using either name. The maximum number of domain names that you can
	// add to an ACM certificate is 100. However, the initial limit is 10 domain
	// names. If you need more than 10 names, you must request a limit increase.
	// For more information, see Limits (https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
	//
	// The maximum length of a SAN DNS name is 253 octets. The name is made up of
	// multiple labels separated by periods. No label can be longer than 63 octets.
	// Consider the following examples:
	//
	//    * (63 octets).(63 octets).(63 octets).(61 octets) is legal because the
	//    total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63
	//    octets.
	//
	//    * (64 octets).(63 octets).(63 octets).(61 octets) is not legal because
	//    the total length exceeds 253 octets (64+1+63+1+63+1+61) and the first
	//    label exceeds 63 octets.
	//
	//    * (63 octets).(63 octets).(63 octets).(62 octets) is not legal because
	//    the total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.
	SubjectAlternativeNames []string `min:"1" type:"list"`

	// One or more resource tags to associate with the certificate.
	Tags []Tag `min:"1" type:"list"`

	// The method you want to use if you are requesting a public certificate to
	// validate that you own or control domain. You can validate with DNS (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html)
	// or validate with email (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html).
	// We recommend that you use DNS validation.
	ValidationMethod ValidationMethod `type:"string" enum:"true"`
}

// String returns the string representation
func (s RequestCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestCertificateInput"}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 20))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 1))
	}
	if s.DomainValidationOptions != nil && len(s.DomainValidationOptions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainValidationOptions", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.SubjectAlternativeNames != nil && len(s.SubjectAlternativeNames) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubjectAlternativeNames", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.DomainValidationOptions != nil {
		for i, v := range s.DomainValidationOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DomainValidationOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RequestCertificateOutput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the issued certificate. This must be of the
	// form:
	//
	// arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
	CertificateArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RequestCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRequestCertificate = "RequestCertificate"

// RequestCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager.
//
// Requests an ACM certificate for use with other AWS services. To request an
// ACM certificate, you must specify a fully qualified domain name (FQDN) in
// the DomainName parameter. You can also specify additional FQDNs in the SubjectAlternativeNames
// parameter.
//
// If you are requesting a private certificate, domain validation is not required.
// If you are requesting a public certificate, each domain name that you specify
// must be validated to verify that you own or control the domain. You can use
// DNS validation (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html)
// or email validation (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html).
// We recommend that you use DNS validation. ACM issues public certificates
// after receiving approval from the domain owner.
//
//    // Example sending a request using RequestCertificateRequest.
//    req := client.RequestCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RequestCertificate
func (c *Client) RequestCertificateRequest(input *RequestCertificateInput) RequestCertificateRequest {
	op := &aws.Operation{
		Name:       opRequestCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCertificateInput{}
	}

	req := c.newRequest(op, input, &RequestCertificateOutput{})
	return RequestCertificateRequest{Request: req, Input: input, Copy: c.RequestCertificateRequest}
}

// RequestCertificateRequest is the request type for the
// RequestCertificate API operation.
type RequestCertificateRequest struct {
	*aws.Request
	Input *RequestCertificateInput
	Copy  func(*RequestCertificateInput) RequestCertificateRequest
}

// Send marshals and sends the RequestCertificate API request.
func (r RequestCertificateRequest) Send(ctx context.Context) (*RequestCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RequestCertificateResponse{
		RequestCertificateOutput: r.Request.Data.(*RequestCertificateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RequestCertificateResponse is the response type for the
// RequestCertificate API operation.
type RequestCertificateResponse struct {
	*RequestCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RequestCertificate request.
func (r *RequestCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
