// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package budgetsiface provides an interface to enable mocking the AWS Budgets service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package budgetsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/budgets"
)

// ClientAPI provides an interface to enable mocking the
// budgets.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWSBudgets.
//    func myFunc(svc budgetsiface.ClientAPI) bool {
//        // Make svc.CreateBudget request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := budgets.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        budgetsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateBudget(input *budgets.CreateBudgetInput) (*budgets.CreateBudgetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateBudgetRequest(*budgets.CreateBudgetInput) budgets.CreateBudgetRequest

	CreateNotificationRequest(*budgets.CreateNotificationInput) budgets.CreateNotificationRequest

	CreateSubscriberRequest(*budgets.CreateSubscriberInput) budgets.CreateSubscriberRequest

	DeleteBudgetRequest(*budgets.DeleteBudgetInput) budgets.DeleteBudgetRequest

	DeleteNotificationRequest(*budgets.DeleteNotificationInput) budgets.DeleteNotificationRequest

	DeleteSubscriberRequest(*budgets.DeleteSubscriberInput) budgets.DeleteSubscriberRequest

	DescribeBudgetRequest(*budgets.DescribeBudgetInput) budgets.DescribeBudgetRequest

	DescribeBudgetPerformanceHistoryRequest(*budgets.DescribeBudgetPerformanceHistoryInput) budgets.DescribeBudgetPerformanceHistoryRequest

	DescribeBudgetsRequest(*budgets.DescribeBudgetsInput) budgets.DescribeBudgetsRequest

	DescribeNotificationsForBudgetRequest(*budgets.DescribeNotificationsForBudgetInput) budgets.DescribeNotificationsForBudgetRequest

	DescribeSubscribersForNotificationRequest(*budgets.DescribeSubscribersForNotificationInput) budgets.DescribeSubscribersForNotificationRequest

	UpdateBudgetRequest(*budgets.UpdateBudgetInput) budgets.UpdateBudgetRequest

	UpdateNotificationRequest(*budgets.UpdateNotificationInput) budgets.UpdateNotificationRequest

	UpdateSubscriberRequest(*budgets.UpdateSubscriberInput) budgets.UpdateSubscriberRequest
}

var _ ClientAPI = (*budgets.Client)(nil)
