// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPullRequestsInput struct {
	_ struct{} `type:"structure"`

	// Optional. The Amazon Resource Name (ARN) of the user who created the pull
	// request. If used, this filters the results to pull requests created by that
	// user.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Optional. The status of the pull request. If used, this refines the results
	// to the pull requests that match the specified status.
	PullRequestStatus PullRequestStatusEnum `locationName:"pullRequestStatus" type:"string" enum:"true"`

	// The name of the repository for which you want to list pull requests.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPullRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPullRequestsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPullRequestsInput"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPullRequestsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the next results
	// of the operation.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The system-generated IDs of the pull requests.
	//
	// PullRequestIds is a required field
	PullRequestIds []string `locationName:"pullRequestIds" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPullRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPullRequests = "ListPullRequests"

// ListPullRequestsRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Returns a list of pull requests for a specified repository. The return list
// can be refined by pull request status or pull request author ARN.
//
//    // Example sending a request using ListPullRequestsRequest.
//    req := client.ListPullRequestsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests
func (c *Client) ListPullRequestsRequest(input *ListPullRequestsInput) ListPullRequestsRequest {
	op := &aws.Operation{
		Name:       opListPullRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPullRequestsInput{}
	}

	req := c.newRequest(op, input, &ListPullRequestsOutput{})
	return ListPullRequestsRequest{Request: req, Input: input, Copy: c.ListPullRequestsRequest}
}

// ListPullRequestsRequest is the request type for the
// ListPullRequests API operation.
type ListPullRequestsRequest struct {
	*aws.Request
	Input *ListPullRequestsInput
	Copy  func(*ListPullRequestsInput) ListPullRequestsRequest
}

// Send marshals and sends the ListPullRequests API request.
func (r ListPullRequestsRequest) Send(ctx context.Context) (*ListPullRequestsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPullRequestsResponse{
		ListPullRequestsOutput: r.Request.Data.(*ListPullRequestsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPullRequestsRequestPaginator returns a paginator for ListPullRequests.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPullRequestsRequest(input)
//   p := codecommit.NewListPullRequestsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPullRequestsPaginator(req ListPullRequestsRequest) ListPullRequestsPaginator {
	return ListPullRequestsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPullRequestsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPullRequestsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPullRequestsPaginator struct {
	aws.Pager
}

func (p *ListPullRequestsPaginator) CurrentPage() *ListPullRequestsOutput {
	return p.Pager.CurrentPage().(*ListPullRequestsOutput)
}

// ListPullRequestsResponse is the response type for the
// ListPullRequests API operation.
type ListPullRequestsResponse struct {
	*ListPullRequestsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPullRequests request.
func (r *ListPullRequestsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
