// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request for a purchase offering.
type PurchaseOfferingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" min:"32" type:"string"`

	// The ID of the offering promotion to be applied to the purchase.
	OfferingPromotionId *string `locationName:"offeringPromotionId" min:"4" type:"string"`

	// The number of device slots you wish to purchase in an offering request.
	Quantity *int64 `locationName:"quantity" type:"integer"`
}

// String returns the string representation
func (s PurchaseOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseOfferingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PurchaseOfferingInput"}
	if s.OfferingId != nil && len(*s.OfferingId) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("OfferingId", 32))
	}
	if s.OfferingPromotionId != nil && len(*s.OfferingPromotionId) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("OfferingPromotionId", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the purchase offering (e.g., success or failure).
type PurchaseOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the offering transaction for the purchase result.
	OfferingTransaction *OfferingTransaction `locationName:"offeringTransaction" type:"structure"`
}

// String returns the string representation
func (s PurchaseOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Immediately purchases offerings for an AWS account. Offerings renew with
// the latest total purchased quantity for an offering, unless the renewal was
// overridden. The API returns a NotEligible error if the user is not permitted
// to invoke the operation. Please contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com) if you believe that you should
// be able to invoke this operation.
//
//    // Example sending a request using PurchaseOfferingRequest.
//    req := client.PurchaseOfferingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering
func (c *Client) PurchaseOfferingRequest(input *PurchaseOfferingInput) PurchaseOfferingRequest {
	op := &aws.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	req := c.newRequest(op, input, &PurchaseOfferingOutput{})
	return PurchaseOfferingRequest{Request: req, Input: input, Copy: c.PurchaseOfferingRequest}
}

// PurchaseOfferingRequest is the request type for the
// PurchaseOffering API operation.
type PurchaseOfferingRequest struct {
	*aws.Request
	Input *PurchaseOfferingInput
	Copy  func(*PurchaseOfferingInput) PurchaseOfferingRequest
}

// Send marshals and sends the PurchaseOffering API request.
func (r PurchaseOfferingRequest) Send(ctx context.Context) (*PurchaseOfferingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PurchaseOfferingResponse{
		PurchaseOfferingOutput: r.Request.Data.(*PurchaseOfferingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PurchaseOfferingResponse is the response type for the
// PurchaseOffering API operation.
type PurchaseOfferingResponse struct {
	*PurchaseOfferingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PurchaseOffering request.
func (r *PurchaseOfferingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
