// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTransitGatewayPeeringAttachmentInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the transit gateway peering attachment.
	//
	// TransitGatewayAttachmentId is a required field
	TransitGatewayAttachmentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTransitGatewayPeeringAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTransitGatewayPeeringAttachmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTransitGatewayPeeringAttachmentInput"}

	if s.TransitGatewayAttachmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayAttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTransitGatewayPeeringAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// The transit gateway peering attachment.
	TransitGatewayPeeringAttachment *TransitGatewayPeeringAttachment `locationName:"transitGatewayPeeringAttachment" type:"structure"`
}

// String returns the string representation
func (s DeleteTransitGatewayPeeringAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTransitGatewayPeeringAttachment = "DeleteTransitGatewayPeeringAttachment"

// DeleteTransitGatewayPeeringAttachmentRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes a transit gateway peering attachment.
//
//    // Example sending a request using DeleteTransitGatewayPeeringAttachmentRequest.
//    req := client.DeleteTransitGatewayPeeringAttachmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment
func (c *Client) DeleteTransitGatewayPeeringAttachmentRequest(input *DeleteTransitGatewayPeeringAttachmentInput) DeleteTransitGatewayPeeringAttachmentRequest {
	op := &aws.Operation{
		Name:       opDeleteTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPeeringAttachmentInput{}
	}

	req := c.newRequest(op, input, &DeleteTransitGatewayPeeringAttachmentOutput{})
	return DeleteTransitGatewayPeeringAttachmentRequest{Request: req, Input: input, Copy: c.DeleteTransitGatewayPeeringAttachmentRequest}
}

// DeleteTransitGatewayPeeringAttachmentRequest is the request type for the
// DeleteTransitGatewayPeeringAttachment API operation.
type DeleteTransitGatewayPeeringAttachmentRequest struct {
	*aws.Request
	Input *DeleteTransitGatewayPeeringAttachmentInput
	Copy  func(*DeleteTransitGatewayPeeringAttachmentInput) DeleteTransitGatewayPeeringAttachmentRequest
}

// Send marshals and sends the DeleteTransitGatewayPeeringAttachment API request.
func (r DeleteTransitGatewayPeeringAttachmentRequest) Send(ctx context.Context) (*DeleteTransitGatewayPeeringAttachmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTransitGatewayPeeringAttachmentResponse{
		DeleteTransitGatewayPeeringAttachmentOutput: r.Request.Data.(*DeleteTransitGatewayPeeringAttachmentOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTransitGatewayPeeringAttachmentResponse is the response type for the
// DeleteTransitGatewayPeeringAttachment API operation.
type DeleteTransitGatewayPeeringAttachmentResponse struct {
	*DeleteTransitGatewayPeeringAttachmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTransitGatewayPeeringAttachment request.
func (r *DeleteTransitGatewayPeeringAttachmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
