// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type PutRolePermissionsBoundaryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy that is used to set the permissions boundary for the
	// role.
	//
	// PermissionsBoundary is a required field
	PermissionsBoundary *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM role for which you want to set
	// the permissions boundary.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRolePermissionsBoundaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRolePermissionsBoundaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRolePermissionsBoundaryInput"}

	if s.PermissionsBoundary == nil {
		invalidParams.Add(aws.NewErrParamRequired("PermissionsBoundary"))
	}
	if s.PermissionsBoundary != nil && len(*s.PermissionsBoundary) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PermissionsBoundary", 20))
	}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutRolePermissionsBoundaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRolePermissionsBoundaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRolePermissionsBoundary = "PutRolePermissionsBoundary"

// PutRolePermissionsBoundaryRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Adds or updates the policy that is specified as the IAM role's permissions
// boundary. You can use an AWS managed policy or a customer managed policy
// to set the boundary for a role. Use the boundary to control the maximum permissions
// that the role can have. Setting a permissions boundary is an advanced feature
// that can affect the permissions for the role.
//
// You cannot set the boundary for a service-linked role.
//
// Policies used as permissions boundaries do not provide permissions. You must
// also attach a permissions policy to the role. To learn how the effective
// permissions for a role are evaluated, see IAM JSON Policy Evaluation Logic
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html)
// in the IAM User Guide.
//
//    // Example sending a request using PutRolePermissionsBoundaryRequest.
//    req := client.PutRolePermissionsBoundaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePermissionsBoundary
func (c *Client) PutRolePermissionsBoundaryRequest(input *PutRolePermissionsBoundaryInput) PutRolePermissionsBoundaryRequest {
	op := &aws.Operation{
		Name:       opPutRolePermissionsBoundary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRolePermissionsBoundaryInput{}
	}

	req := c.newRequest(op, input, &PutRolePermissionsBoundaryOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutRolePermissionsBoundaryRequest{Request: req, Input: input, Copy: c.PutRolePermissionsBoundaryRequest}
}

// PutRolePermissionsBoundaryRequest is the request type for the
// PutRolePermissionsBoundary API operation.
type PutRolePermissionsBoundaryRequest struct {
	*aws.Request
	Input *PutRolePermissionsBoundaryInput
	Copy  func(*PutRolePermissionsBoundaryInput) PutRolePermissionsBoundaryRequest
}

// Send marshals and sends the PutRolePermissionsBoundary API request.
func (r PutRolePermissionsBoundaryRequest) Send(ctx context.Context) (*PutRolePermissionsBoundaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRolePermissionsBoundaryResponse{
		PutRolePermissionsBoundaryOutput: r.Request.Data.(*PutRolePermissionsBoundaryOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRolePermissionsBoundaryResponse is the response type for the
// PutRolePermissionsBoundary API operation.
type PutRolePermissionsBoundaryResponse struct {
	*PutRolePermissionsBoundaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRolePermissionsBoundary request.
func (r *PutRolePermissionsBoundaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
