// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetFlowTemplateRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetFlowTemplateRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowTemplateRevisionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFlowTemplateRevisionsInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetFlowTemplateRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that provide summary data about each revision.
	Summaries []FlowTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s GetFlowTemplateRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetFlowTemplateRevisions = "GetFlowTemplateRevisions"

// GetFlowTemplateRevisionsRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Gets revisions of the specified workflow. Only the last 100 revisions are
// stored. If the workflow has been deprecated, this action will return revisions
// that occurred before the deprecation. This action won't work for workflows
// that have been deleted.
//
//    // Example sending a request using GetFlowTemplateRevisionsRequest.
//    req := client.GetFlowTemplateRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions
func (c *Client) GetFlowTemplateRevisionsRequest(input *GetFlowTemplateRevisionsInput) GetFlowTemplateRevisionsRequest {
	op := &aws.Operation{
		Name:       opGetFlowTemplateRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFlowTemplateRevisionsInput{}
	}

	req := c.newRequest(op, input, &GetFlowTemplateRevisionsOutput{})
	return GetFlowTemplateRevisionsRequest{Request: req, Input: input, Copy: c.GetFlowTemplateRevisionsRequest}
}

// GetFlowTemplateRevisionsRequest is the request type for the
// GetFlowTemplateRevisions API operation.
type GetFlowTemplateRevisionsRequest struct {
	*aws.Request
	Input *GetFlowTemplateRevisionsInput
	Copy  func(*GetFlowTemplateRevisionsInput) GetFlowTemplateRevisionsRequest
}

// Send marshals and sends the GetFlowTemplateRevisions API request.
func (r GetFlowTemplateRevisionsRequest) Send(ctx context.Context) (*GetFlowTemplateRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFlowTemplateRevisionsResponse{
		GetFlowTemplateRevisionsOutput: r.Request.Data.(*GetFlowTemplateRevisionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetFlowTemplateRevisionsRequestPaginator returns a paginator for GetFlowTemplateRevisions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetFlowTemplateRevisionsRequest(input)
//   p := iotthingsgraph.NewGetFlowTemplateRevisionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetFlowTemplateRevisionsPaginator(req GetFlowTemplateRevisionsRequest) GetFlowTemplateRevisionsPaginator {
	return GetFlowTemplateRevisionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetFlowTemplateRevisionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetFlowTemplateRevisionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetFlowTemplateRevisionsPaginator struct {
	aws.Pager
}

func (p *GetFlowTemplateRevisionsPaginator) CurrentPage() *GetFlowTemplateRevisionsOutput {
	return p.Pager.CurrentPage().(*GetFlowTemplateRevisionsOutput)
}

// GetFlowTemplateRevisionsResponse is the response type for the
// GetFlowTemplateRevisions API operation.
type GetFlowTemplateRevisionsResponse struct {
	*GetFlowTemplateRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFlowTemplateRevisions request.
func (r *GetFlowTemplateRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
