// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// A description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// Whether to certify the algorithm so that it can be listed in AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// Specifies details about inference jobs that the algorithm runs, including
	// the following:
	//
	//    * The Amazon ECR paths of containers that contain the inference code and
	//    model artifacts.
	//
	//    * The instance types that the algorithm supports for transform jobs and
	//    real-time endpoints used for inference.
	//
	//    * The input and output content formats that the algorithm supports for
	//    inference.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// Specifies details about training jobs run by this algorithm, including the
	// following:
	//
	//    * The Amazon ECR path of the container and the version digest of the algorithm.
	//
	//    * The hyperparameters that the algorithm supports.
	//
	//    * The instance types that the algorithm supports for training.
	//
	//    * Whether the algorithm supports distributed training.
	//
	//    * The metrics that the algorithm emits to Amazon CloudWatch.
	//
	//    * Which metrics that the algorithm emits can be used as the objective
	//    metric for hyperparameter tuning jobs.
	//
	//    * The input channels that the algorithm supports for training data. For
	//    example, an algorithm might support train, validation, and test channels.
	//
	// TrainingSpecification is a required field
	TrainingSpecification *TrainingSpecification `type:"structure" required:"true"`

	// Specifies configurations for one or more training jobs and that Amazon SageMaker
	// runs to test the algorithm's training code and, optionally, one or more batch
	// transform jobs that Amazon SageMaker runs to test the algorithm's inference
	// code.
	ValidationSpecification *AlgorithmValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s CreateAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAlgorithmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAlgorithmInput"}

	if s.AlgorithmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}

	if s.TrainingSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingSpecification"))
	}
	if s.InferenceSpecification != nil {
		if err := s.InferenceSpecification.Validate(); err != nil {
			invalidParams.AddNested("InferenceSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrainingSpecification != nil {
		if err := s.TrainingSpecification.Validate(); err != nil {
			invalidParams.AddNested("TrainingSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.ValidationSpecification != nil {
		if err := s.ValidationSpecification.Validate(); err != nil {
			invalidParams.AddNested("ValidationSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAlgorithm = "CreateAlgorithm"

// CreateAlgorithmRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Create a machine learning algorithm that you can use in Amazon SageMaker
// and list in the AWS Marketplace.
//
//    // Example sending a request using CreateAlgorithmRequest.
//    req := client.CreateAlgorithmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm
func (c *Client) CreateAlgorithmRequest(input *CreateAlgorithmInput) CreateAlgorithmRequest {
	op := &aws.Operation{
		Name:       opCreateAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAlgorithmInput{}
	}

	req := c.newRequest(op, input, &CreateAlgorithmOutput{})
	return CreateAlgorithmRequest{Request: req, Input: input, Copy: c.CreateAlgorithmRequest}
}

// CreateAlgorithmRequest is the request type for the
// CreateAlgorithm API operation.
type CreateAlgorithmRequest struct {
	*aws.Request
	Input *CreateAlgorithmInput
	Copy  func(*CreateAlgorithmInput) CreateAlgorithmRequest
}

// Send marshals and sends the CreateAlgorithm API request.
func (r CreateAlgorithmRequest) Send(ctx context.Context) (*CreateAlgorithmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAlgorithmResponse{
		CreateAlgorithmOutput: r.Request.Data.(*CreateAlgorithmOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAlgorithmResponse is the response type for the
// CreateAlgorithm API operation.
type CreateAlgorithmResponse struct {
	*CreateAlgorithmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAlgorithm request.
func (r *CreateAlgorithmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
