// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRegistryInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegistryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRegistryInput"}

	if s.RegistryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRegistryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "registryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRegistryOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RegistryArn *string `type:"string"`

	RegistryName *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdateRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRegistryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryArn != nil {
		v := *s.RegistryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegistryArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegistryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opUpdateRegistry = "UpdateRegistry"

// UpdateRegistryRequest returns a request value for making API operation for
// Schemas.
//
// Updates a registry.
//
//    // Example sending a request using UpdateRegistryRequest.
//    req := client.UpdateRegistryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry
func (c *Client) UpdateRegistryRequest(input *UpdateRegistryInput) UpdateRegistryRequest {
	op := &aws.Operation{
		Name:       opUpdateRegistry,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &UpdateRegistryInput{}
	}

	req := c.newRequest(op, input, &UpdateRegistryOutput{})
	return UpdateRegistryRequest{Request: req, Input: input, Copy: c.UpdateRegistryRequest}
}

// UpdateRegistryRequest is the request type for the
// UpdateRegistry API operation.
type UpdateRegistryRequest struct {
	*aws.Request
	Input *UpdateRegistryInput
	Copy  func(*UpdateRegistryInput) UpdateRegistryRequest
}

// Send marshals and sends the UpdateRegistry API request.
func (r UpdateRegistryRequest) Send(ctx context.Context) (*UpdateRegistryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRegistryResponse{
		UpdateRegistryOutput: r.Request.Data.(*UpdateRegistryOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRegistryResponse is the response type for the
// UpdateRegistry API operation.
type UpdateRegistryResponse struct {
	*UpdateRegistryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRegistry request.
func (r *UpdateRegistryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
