// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListBudgetsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListBudgetsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBudgetsForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBudgetsForResourceInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListBudgetsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associated budgets.
	Budgets []BudgetDetail `type:"list"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListBudgetsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBudgetsForResource = "ListBudgetsForResource"

// ListBudgetsForResourceRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists all the budgets associated to the specified resource.
//
//    // Example sending a request using ListBudgetsForResourceRequest.
//    req := client.ListBudgetsForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource
func (c *Client) ListBudgetsForResourceRequest(input *ListBudgetsForResourceInput) ListBudgetsForResourceRequest {
	op := &aws.Operation{
		Name:       opListBudgetsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBudgetsForResourceInput{}
	}

	req := c.newRequest(op, input, &ListBudgetsForResourceOutput{})
	return ListBudgetsForResourceRequest{Request: req, Input: input, Copy: c.ListBudgetsForResourceRequest}
}

// ListBudgetsForResourceRequest is the request type for the
// ListBudgetsForResource API operation.
type ListBudgetsForResourceRequest struct {
	*aws.Request
	Input *ListBudgetsForResourceInput
	Copy  func(*ListBudgetsForResourceInput) ListBudgetsForResourceRequest
}

// Send marshals and sends the ListBudgetsForResource API request.
func (r ListBudgetsForResourceRequest) Send(ctx context.Context) (*ListBudgetsForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBudgetsForResourceResponse{
		ListBudgetsForResourceOutput: r.Request.Data.(*ListBudgetsForResourceOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBudgetsForResourceRequestPaginator returns a paginator for ListBudgetsForResource.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBudgetsForResourceRequest(input)
//   p := servicecatalog.NewListBudgetsForResourceRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBudgetsForResourcePaginator(req ListBudgetsForResourceRequest) ListBudgetsForResourcePaginator {
	return ListBudgetsForResourcePaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBudgetsForResourceInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBudgetsForResourcePaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBudgetsForResourcePaginator struct {
	aws.Pager
}

func (p *ListBudgetsForResourcePaginator) CurrentPage() *ListBudgetsForResourceOutput {
	return p.Pager.CurrentPage().(*ListBudgetsForResourceOutput)
}

// ListBudgetsForResourceResponse is the response type for the
// ListBudgetsForResource API operation.
type ListBudgetsForResourceResponse struct {
	*ListBudgetsForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBudgetsForResource request.
func (r *ListBudgetsForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
