// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// A unique system-assigned identifier for an SFTP server instance.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteServerInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// Deletes the Secure File Transfer Protocol (SFTP) server that you specify.
//
// No response returns from this operation.
//
//    // Example sending a request using DeleteServerRequest.
//    req := client.DeleteServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Client) DeleteServerRequest(input *DeleteServerInput) DeleteServerRequest {
	op := &aws.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	req := c.newRequest(op, input, &DeleteServerOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteServerRequest{Request: req, Input: input, Copy: c.DeleteServerRequest}
}

// DeleteServerRequest is the request type for the
// DeleteServer API operation.
type DeleteServerRequest struct {
	*aws.Request
	Input *DeleteServerInput
	Copy  func(*DeleteServerInput) DeleteServerRequest
}

// Send marshals and sends the DeleteServer API request.
func (r DeleteServerRequest) Send(ctx context.Context) (*DeleteServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteServerResponse{
		DeleteServerOutput: r.Request.Data.(*DeleteServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteServerResponse is the response type for the
// DeleteServer API operation.
type DeleteServerResponse struct {
	*DeleteServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteServer request.
func (r *DeleteServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
