// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AddTagsToCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM certificate to which the tag is to
	// be applied. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag. The tag value is optional.
	//
	// Tags is a required field
	Tags []Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddTagsToCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 20))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddTagsToCertificate = "AddTagsToCertificate"

// AddTagsToCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager.
//
// Adds one or more tags to an ACM certificate. Tags are labels that you can
// use to identify and organize your AWS resources. Each tag consists of a key
// and an optional value. You specify the certificate on input by its Amazon
// Resource Name (ARN). You specify the tag by using a key-value pair.
//
// You can apply a tag to just one certificate if you want to identify a specific
// characteristic of that certificate, or you can apply the same tag to multiple
// certificates if you want to filter for a common relationship among those
// certificates. Similarly, you can apply the same tag to multiple resources
// if you want to specify a relationship among those resources. For example,
// you can add the same tag to an ACM certificate and an Elastic Load Balancing
// load balancer to indicate that they are both used by the same website. For
// more information, see Tagging ACM certificates (https://docs.aws.amazon.com/acm/latest/userguide/tags.html).
//
// To remove one or more tags, use the RemoveTagsFromCertificate action. To
// view all of the tags that have been applied to the certificate, use the ListTagsForCertificate
// action.
//
//    // Example sending a request using AddTagsToCertificateRequest.
//    req := client.AddTagsToCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/AddTagsToCertificate
func (c *Client) AddTagsToCertificateRequest(input *AddTagsToCertificateInput) AddTagsToCertificateRequest {
	op := &aws.Operation{
		Name:       opAddTagsToCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToCertificateInput{}
	}

	req := c.newRequest(op, input, &AddTagsToCertificateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AddTagsToCertificateRequest{Request: req, Input: input, Copy: c.AddTagsToCertificateRequest}
}

// AddTagsToCertificateRequest is the request type for the
// AddTagsToCertificate API operation.
type AddTagsToCertificateRequest struct {
	*aws.Request
	Input *AddTagsToCertificateInput
	Copy  func(*AddTagsToCertificateInput) AddTagsToCertificateRequest
}

// Send marshals and sends the AddTagsToCertificate API request.
func (r AddTagsToCertificateRequest) Send(ctx context.Context) (*AddTagsToCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddTagsToCertificateResponse{
		AddTagsToCertificateOutput: r.Request.Data.(*AddTagsToCertificateOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddTagsToCertificateResponse is the response type for the
// AddTagsToCertificate API operation.
type AddTagsToCertificateResponse struct {
	*AddTagsToCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddTagsToCertificate request.
func (r *AddTagsToCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
