// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The route settings map.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// The stage variable map.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStageInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.AutoDeploy != nil {
		v := *s.AutoDeploy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeploy", protocol.BoolValue(v), metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteSettings != nil {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The route settings map.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`

	// The stage variable map.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.ApiGatewayManaged != nil {
		v := *s.ApiGatewayManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayManaged", protocol.BoolValue(v), metadata)
	}
	if s.AutoDeploy != nil {
		v := *s.AutoDeploy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeploy", protocol.BoolValue(v), metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentStatusMessage != nil {
		v := *s.LastDeploymentStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.RouteSettings != nil {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opCreateStage = "CreateStage"

// CreateStageRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Creates a Stage for an API.
//
//    // Example sending a request using CreateStageRequest.
//    req := client.CreateStageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateStage
func (c *Client) CreateStageRequest(input *CreateStageInput) CreateStageRequest {
	op := &aws.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/stages",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	req := c.newRequest(op, input, &CreateStageOutput{})
	return CreateStageRequest{Request: req, Input: input, Copy: c.CreateStageRequest}
}

// CreateStageRequest is the request type for the
// CreateStage API operation.
type CreateStageRequest struct {
	*aws.Request
	Input *CreateStageInput
	Copy  func(*CreateStageInput) CreateStageRequest
}

// Send marshals and sends the CreateStage API request.
func (r CreateStageRequest) Send(ctx context.Context) (*CreateStageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateStageResponse{
		CreateStageOutput: r.Request.Data.(*CreateStageOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateStageResponse is the response type for the
// CreateStage API operation.
type CreateStageResponse struct {
	*CreateStageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateStage request.
func (r *CreateStageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
