// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// A list of additional authentication providers for the GraphqlApi API.
	AdditionalAuthenticationProviders []AdditionalAuthenticationProvider `locationName:"additionalAuthenticationProviders" type:"list"`

	// The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
	//
	// AuthenticationType is a required field
	AuthenticationType AuthenticationType `locationName:"authenticationType" type:"string" required:"true" enum:"true"`

	// The Amazon CloudWatch Logs configuration.
	LogConfig *LogConfig `locationName:"logConfig" type:"structure"`

	// A user-supplied name for the GraphqlApi.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The OpenID Connect configuration.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// A TagMap object.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *UserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s CreateGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGraphqlApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGraphqlApiInput"}
	if len(s.AuthenticationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.AdditionalAuthenticationProviders != nil {
		for i, v := range s.AdditionalAuthenticationProviders {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdditionalAuthenticationProviders", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LogConfig != nil {
		if err := s.LogConfig.Validate(); err != nil {
			invalidParams.AddNested("LogConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.OpenIDConnectConfig != nil {
		if err := s.OpenIDConnectConfig.Validate(); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.UserPoolConfig != nil {
		if err := s.UserPoolConfig.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGraphqlApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AdditionalAuthenticationProviders != nil {
		v := s.AdditionalAuthenticationProviders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "additionalAuthenticationProviders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.AuthenticationType) > 0 {
		v := s.AuthenticationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authenticationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LogConfig != nil {
		v := s.LogConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logConfig", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OpenIDConnectConfig != nil {
		v := s.OpenIDConnectConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "openIDConnectConfig", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UserPoolConfig != nil {
		v := s.UserPoolConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "userPoolConfig", v, metadata)
	}
	return nil
}

type CreateGraphqlApiOutput struct {
	_ struct{} `type:"structure"`

	// The GraphqlApi.
	GraphqlApi *GraphqlApi `locationName:"graphqlApi" type:"structure"`
}

// String returns the string representation
func (s CreateGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGraphqlApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GraphqlApi != nil {
		v := s.GraphqlApi

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "graphqlApi", v, metadata)
	}
	return nil
}

const opCreateGraphqlApi = "CreateGraphqlApi"

// CreateGraphqlApiRequest returns a request value for making API operation for
// AWS AppSync.
//
// Creates a GraphqlApi object.
//
//    // Example sending a request using CreateGraphqlApiRequest.
//    req := client.CreateGraphqlApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi
func (c *Client) CreateGraphqlApiRequest(input *CreateGraphqlApiInput) CreateGraphqlApiRequest {
	op := &aws.Operation{
		Name:       opCreateGraphqlApi,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis",
	}

	if input == nil {
		input = &CreateGraphqlApiInput{}
	}

	req := c.newRequest(op, input, &CreateGraphqlApiOutput{})
	return CreateGraphqlApiRequest{Request: req, Input: input, Copy: c.CreateGraphqlApiRequest}
}

// CreateGraphqlApiRequest is the request type for the
// CreateGraphqlApi API operation.
type CreateGraphqlApiRequest struct {
	*aws.Request
	Input *CreateGraphqlApiInput
	Copy  func(*CreateGraphqlApiInput) CreateGraphqlApiRequest
}

// Send marshals and sends the CreateGraphqlApi API request.
func (r CreateGraphqlApiRequest) Send(ctx context.Context) (*CreateGraphqlApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGraphqlApiResponse{
		CreateGraphqlApiOutput: r.Request.Data.(*CreateGraphqlApiOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGraphqlApiResponse is the response type for the
// CreateGraphqlApi API operation.
type CreateGraphqlApiResponse struct {
	*CreateGraphqlApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGraphqlApi request.
func (r *CreateGraphqlApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
