// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAttachedIndicesInput struct {
	_ struct{} `type:"structure"`

	// The consistency level to use for this operation.
	ConsistencyLevel ConsistencyLevel `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"true"`

	// The ARN of the directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A reference to the object that has indices attached.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListAttachedIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedIndicesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAttachedIndicesInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TargetReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAttachedIndicesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetReference != nil {
		v := s.TargetReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetReference", v, metadata)
	}
	if len(s.ConsistencyLevel) > 0 {
		v := s.ConsistencyLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-consistency-level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListAttachedIndicesOutput struct {
	_ struct{} `type:"structure"`

	// The indices attached to the specified object.
	IndexAttachments []IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAttachedIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAttachedIndicesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.IndexAttachments != nil {
		v := s.IndexAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IndexAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListAttachedIndices = "ListAttachedIndices"

// ListAttachedIndicesRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Lists indices attached to the specified object.
//
//    // Example sending a request using ListAttachedIndicesRequest.
//    req := client.ListAttachedIndicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices
func (c *Client) ListAttachedIndicesRequest(input *ListAttachedIndicesInput) ListAttachedIndicesRequest {
	op := &aws.Operation{
		Name:       opListAttachedIndices,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/indices",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttachedIndicesInput{}
	}

	req := c.newRequest(op, input, &ListAttachedIndicesOutput{})
	return ListAttachedIndicesRequest{Request: req, Input: input, Copy: c.ListAttachedIndicesRequest}
}

// ListAttachedIndicesRequest is the request type for the
// ListAttachedIndices API operation.
type ListAttachedIndicesRequest struct {
	*aws.Request
	Input *ListAttachedIndicesInput
	Copy  func(*ListAttachedIndicesInput) ListAttachedIndicesRequest
}

// Send marshals and sends the ListAttachedIndices API request.
func (r ListAttachedIndicesRequest) Send(ctx context.Context) (*ListAttachedIndicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAttachedIndicesResponse{
		ListAttachedIndicesOutput: r.Request.Data.(*ListAttachedIndicesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAttachedIndicesRequestPaginator returns a paginator for ListAttachedIndices.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAttachedIndicesRequest(input)
//   p := clouddirectory.NewListAttachedIndicesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAttachedIndicesPaginator(req ListAttachedIndicesRequest) ListAttachedIndicesPaginator {
	return ListAttachedIndicesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAttachedIndicesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAttachedIndicesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAttachedIndicesPaginator struct {
	aws.Pager
}

func (p *ListAttachedIndicesPaginator) CurrentPage() *ListAttachedIndicesOutput {
	return p.Pager.CurrentPage().(*ListAttachedIndicesOutput)
}

// ListAttachedIndicesResponse is the response type for the
// ListAttachedIndices API operation.
type ListAttachedIndicesResponse struct {
	*ListAttachedIndicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAttachedIndices request.
func (r *ListAttachedIndicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
