// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to stop the operation
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackSetOperationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopStackSetOperationInput"}

	if s.OperationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopStackSetOperationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopStackSetOperation = "StopStackSetOperation"

// StopStackSetOperationRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Stops an in-progress operation on a stack set and its associated stack instances.
//
//    // Example sending a request using StopStackSetOperationRequest.
//    req := client.StopStackSetOperationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *Client) StopStackSetOperationRequest(input *StopStackSetOperationInput) StopStackSetOperationRequest {
	op := &aws.Operation{
		Name:       opStopStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackSetOperationInput{}
	}

	req := c.newRequest(op, input, &StopStackSetOperationOutput{})
	return StopStackSetOperationRequest{Request: req, Input: input, Copy: c.StopStackSetOperationRequest}
}

// StopStackSetOperationRequest is the request type for the
// StopStackSetOperation API operation.
type StopStackSetOperationRequest struct {
	*aws.Request
	Input *StopStackSetOperationInput
	Copy  func(*StopStackSetOperationInput) StopStackSetOperationRequest
}

// Send marshals and sends the StopStackSetOperation API request.
func (r StopStackSetOperationRequest) Send(ctx context.Context) (*StopStackSetOperationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopStackSetOperationResponse{
		StopStackSetOperationOutput: r.Request.Data.(*StopStackSetOperationOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopStackSetOperationResponse is the response type for the
// StopStackSetOperation API operation.
type StopStackSetOperationResponse struct {
	*StopStackSetOperationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopStackSetOperation request.
func (r *StopStackSetOperationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
