// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeDomains operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular expressions, specify the names of the expressions you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeExpressionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Limits the DescribeExpressions response to the specified expressions. If
	// not specified, all expressions are shown.
	ExpressionNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeExpressionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExpressionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExpressionsInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeExpressions request. Contains the expressions configured
// for the domain specified in the request.
type DescribeExpressionsOutput struct {
	_ struct{} `type:"structure"`

	// The expressions configured for the domain.
	//
	// Expressions is a required field
	Expressions []ExpressionStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeExpressionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeExpressions = "DescribeExpressions"

// DescribeExpressionsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets the expressions configured for the search domain. Can be limited to
// specific expressions by name. By default, shows all expressions and includes
// any pending changes to the configuration. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeExpressionsRequest.
//    req := client.DescribeExpressionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeExpressionsRequest(input *DescribeExpressionsInput) DescribeExpressionsRequest {
	op := &aws.Operation{
		Name:       opDescribeExpressions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExpressionsInput{}
	}

	req := c.newRequest(op, input, &DescribeExpressionsOutput{})
	return DescribeExpressionsRequest{Request: req, Input: input, Copy: c.DescribeExpressionsRequest}
}

// DescribeExpressionsRequest is the request type for the
// DescribeExpressions API operation.
type DescribeExpressionsRequest struct {
	*aws.Request
	Input *DescribeExpressionsInput
	Copy  func(*DescribeExpressionsInput) DescribeExpressionsRequest
}

// Send marshals and sends the DescribeExpressions API request.
func (r DescribeExpressionsRequest) Send(ctx context.Context) (*DescribeExpressionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeExpressionsResponse{
		DescribeExpressionsOutput: r.Request.Data.(*DescribeExpressionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeExpressionsResponse is the response type for the
// DescribeExpressions API operation.
type DescribeExpressionsResponse struct {
	*DescribeExpressionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeExpressions request.
func (r *DescribeExpressionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
