// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The metric dimensions associated with the anomaly detection model to delete.
	Dimensions []Dimension `type:"list"`

	// The metric name associated with the anomaly detection model to delete.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace associated with the anomaly detection model to delete.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The statistic associated with the anomaly detection model to delete.
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalyDetectorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAnomalyDetectorInput"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Stat == nil {
		invalidParams.Add(aws.NewErrParamRequired("Stat"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAnomalyDetector = "DeleteAnomalyDetector"

// DeleteAnomalyDetectorRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Deletes the specified anomaly detection model from your account.
//
//    // Example sending a request using DeleteAnomalyDetectorRequest.
//    req := client.DeleteAnomalyDetectorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAnomalyDetector
func (c *Client) DeleteAnomalyDetectorRequest(input *DeleteAnomalyDetectorInput) DeleteAnomalyDetectorRequest {
	op := &aws.Operation{
		Name:       opDeleteAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalyDetectorInput{}
	}

	req := c.newRequest(op, input, &DeleteAnomalyDetectorOutput{})
	return DeleteAnomalyDetectorRequest{Request: req, Input: input, Copy: c.DeleteAnomalyDetectorRequest}
}

// DeleteAnomalyDetectorRequest is the request type for the
// DeleteAnomalyDetector API operation.
type DeleteAnomalyDetectorRequest struct {
	*aws.Request
	Input *DeleteAnomalyDetectorInput
	Copy  func(*DeleteAnomalyDetectorInput) DeleteAnomalyDetectorRequest
}

// Send marshals and sends the DeleteAnomalyDetector API request.
func (r DeleteAnomalyDetectorRequest) Send(ctx context.Context) (*DeleteAnomalyDetectorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAnomalyDetectorResponse{
		DeleteAnomalyDetectorOutput: r.Request.Data.(*DeleteAnomalyDetectorOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAnomalyDetectorResponse is the response type for the
// DeleteAnomalyDetector API operation.
type DeleteAnomalyDetectorResponse struct {
	*DeleteAnomalyDetectorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAnomalyDetector request.
func (r *DeleteAnomalyDetectorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
