// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type PutSubscriptionFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination to deliver matching log events to. Currently,
	// the supported destinations are:
	//
	//    * An Amazon Kinesis stream belonging to the same account as the subscription
	//    filter, for same-account delivery.
	//
	//    * A logical destination (specified using an ARN) belonging to a different
	//    account, for cross-account delivery.
	//
	//    * An Amazon Kinesis Firehose delivery stream belonging to the same account
	//    as the subscription filter, for same-account delivery.
	//
	//    * An AWS Lambda function belonging to the same account as the subscription
	//    filter, for same-account delivery.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"1" type:"string" required:"true"`

	// The method used to distribute log data to the destination. By default log
	// data is grouped by log stream, but the grouping can be set to random for
	// a more even distribution. This property is only applicable when the destination
	// is an Amazon Kinesis stream.
	Distribution Distribution `locationName:"distribution" type:"string" enum:"true"`

	// A name for the subscription filter. If you are updating an existing filter,
	// you must specify the correct name in filterName. Otherwise, the call fails
	// because you cannot associate a second filter with a log group. To find the
	// name of the filter currently associated with a log group, use DescribeSubscriptionFilters.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// A filter pattern for subscribing to a filtered stream of log events.
	//
	// FilterPattern is a required field
	FilterPattern *string `locationName:"filterPattern" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The ARN of an IAM role that grants CloudWatch Logs permissions to deliver
	// ingested log events to the destination stream. You don't need to provide
	// the ARN when you are working with a logical destination for cross-account
	// delivery.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s PutSubscriptionFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSubscriptionFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutSubscriptionFilterInput"}

	if s.DestinationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationArn", 1))
	}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.FilterPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterPattern"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutSubscriptionFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutSubscriptionFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutSubscriptionFilter = "PutSubscriptionFilter"

// PutSubscriptionFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates a subscription filter and associates it with the specified
// log group. Subscription filters allow you to subscribe to a real-time stream
// of log events ingested through PutLogEvents and have them delivered to a
// specific destination. Currently, the supported destinations are:
//
//    * An Amazon Kinesis stream belonging to the same account as the subscription
//    filter, for same-account delivery.
//
//    * A logical destination that belongs to a different account, for cross-account
//    delivery.
//
//    * An Amazon Kinesis Firehose delivery stream that belongs to the same
//    account as the subscription filter, for same-account delivery.
//
//    * An AWS Lambda function that belongs to the same account as the subscription
//    filter, for same-account delivery.
//
// There can only be one subscription filter associated with a log group. If
// you are updating an existing filter, you must specify the correct name in
// filterName. Otherwise, the call fails because you cannot associate a second
// filter with a log group.
//
//    // Example sending a request using PutSubscriptionFilterRequest.
//    req := client.PutSubscriptionFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilter
func (c *Client) PutSubscriptionFilterRequest(input *PutSubscriptionFilterInput) PutSubscriptionFilterRequest {
	op := &aws.Operation{
		Name:       opPutSubscriptionFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSubscriptionFilterInput{}
	}

	req := c.newRequest(op, input, &PutSubscriptionFilterOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutSubscriptionFilterRequest{Request: req, Input: input, Copy: c.PutSubscriptionFilterRequest}
}

// PutSubscriptionFilterRequest is the request type for the
// PutSubscriptionFilter API operation.
type PutSubscriptionFilterRequest struct {
	*aws.Request
	Input *PutSubscriptionFilterInput
	Copy  func(*PutSubscriptionFilterInput) PutSubscriptionFilterRequest
}

// Send marshals and sends the PutSubscriptionFilter API request.
func (r PutSubscriptionFilterRequest) Send(ctx context.Context) (*PutSubscriptionFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutSubscriptionFilterResponse{
		PutSubscriptionFilterOutput: r.Request.Data.(*PutSubscriptionFilterOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutSubscriptionFilterResponse is the response type for the
// PutSubscriptionFilter API operation.
type PutSubscriptionFilterResponse struct {
	*PutSubscriptionFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutSubscriptionFilter request.
func (r *PutSubscriptionFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
