// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeOrganizationConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of organization config packs returned on each page. If
	// you do no specify a number, AWS Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name that you assign to an organization conformance pack.
	OrganizationConformancePackNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeOrganizationConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of OrganizationConformancePacks objects.
	OrganizationConformancePacks []OrganizationConformancePack `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOrganizationConformancePacks = "DescribeOrganizationConformancePacks"

// DescribeOrganizationConformancePacksRequest returns a request value for making API operation for
// AWS Config.
//
// Returns a list of organization conformance packs.
//
// When you specify the limit and the next token, you receive a paginated response.
//
// Limit and next token are not applicable if you specify organization conformance
// packs names. They are only applicable, when you request all the organization
// conformance packs.
//
// Only a master account can call this API.
//
//    // Example sending a request using DescribeOrganizationConformancePacksRequest.
//    req := client.DescribeOrganizationConformancePacksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks
func (c *Client) DescribeOrganizationConformancePacksRequest(input *DescribeOrganizationConformancePacksInput) DescribeOrganizationConformancePacksRequest {
	op := &aws.Operation{
		Name:       opDescribeOrganizationConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConformancePacksInput{}
	}

	req := c.newRequest(op, input, &DescribeOrganizationConformancePacksOutput{})
	return DescribeOrganizationConformancePacksRequest{Request: req, Input: input, Copy: c.DescribeOrganizationConformancePacksRequest}
}

// DescribeOrganizationConformancePacksRequest is the request type for the
// DescribeOrganizationConformancePacks API operation.
type DescribeOrganizationConformancePacksRequest struct {
	*aws.Request
	Input *DescribeOrganizationConformancePacksInput
	Copy  func(*DescribeOrganizationConformancePacksInput) DescribeOrganizationConformancePacksRequest
}

// Send marshals and sends the DescribeOrganizationConformancePacks API request.
func (r DescribeOrganizationConformancePacksRequest) Send(ctx context.Context) (*DescribeOrganizationConformancePacksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrganizationConformancePacksResponse{
		DescribeOrganizationConformancePacksOutput: r.Request.Data.(*DescribeOrganizationConformancePacksOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOrganizationConformancePacksResponse is the response type for the
// DescribeOrganizationConformancePacks API operation.
type DescribeOrganizationConformancePacksResponse struct {
	*DescribeOrganizationConformancePacksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrganizationConformancePacks request.
func (r *DescribeOrganizationConformancePacksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
