// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type AuthorizeSecurityGroupEgressInput struct {
	_ struct{} `type:"structure"`

	// Not supported. Use a set of IP permissions to specify the CIDR.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Not supported. Use a set of IP permissions to specify the port.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The ID of the security group.
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" type:"string" required:"true"`

	// The sets of IP permissions. You can't specify a destination security group
	// and a CIDR IP address range in the same set of permissions.
	IpPermissions []IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// Not supported. Use a set of IP permissions to specify the protocol name or
	// number.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// Not supported. Use a set of IP permissions to specify a destination security
	// group.
	SourceSecurityGroupName *string `locationName:"sourceSecurityGroupName" type:"string"`

	// Not supported. Use a set of IP permissions to specify a destination security
	// group.
	SourceSecurityGroupOwnerId *string `locationName:"sourceSecurityGroupOwnerId" type:"string"`

	// Not supported. Use a set of IP permissions to specify the port.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeSecurityGroupEgressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthorizeSecurityGroupEgressInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AuthorizeSecurityGroupEgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressOutput) String() string {
	return awsutil.Prettify(s)
}

const opAuthorizeSecurityGroupEgress = "AuthorizeSecurityGroupEgress"

// AuthorizeSecurityGroupEgressRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// [VPC only] Adds the specified egress rules to a security group for use with
// a VPC.
//
// An outbound rule permits instances to send traffic to the specified IPv4
// or IPv6 CIDR address ranges, or to the instances associated with the specified
// destination security groups.
//
// You specify a protocol for each rule (for example, TCP). For the TCP and
// UDP protocols, you must also specify the destination port or port range.
// For the ICMP protocol, you must also specify the ICMP type and code. You
// can use -1 for the type or code to mean all types or all codes.
//
// Rule changes are propagated to affected instances as quickly as possible.
// However, a small delay might occur.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
//    // Example sending a request using AuthorizeSecurityGroupEgressRequest.
//    req := client.AuthorizeSecurityGroupEgressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *Client) AuthorizeSecurityGroupEgressRequest(input *AuthorizeSecurityGroupEgressInput) AuthorizeSecurityGroupEgressRequest {
	op := &aws.Operation{
		Name:       opAuthorizeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupEgressInput{}
	}

	req := c.newRequest(op, input, &AuthorizeSecurityGroupEgressOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AuthorizeSecurityGroupEgressRequest{Request: req, Input: input, Copy: c.AuthorizeSecurityGroupEgressRequest}
}

// AuthorizeSecurityGroupEgressRequest is the request type for the
// AuthorizeSecurityGroupEgress API operation.
type AuthorizeSecurityGroupEgressRequest struct {
	*aws.Request
	Input *AuthorizeSecurityGroupEgressInput
	Copy  func(*AuthorizeSecurityGroupEgressInput) AuthorizeSecurityGroupEgressRequest
}

// Send marshals and sends the AuthorizeSecurityGroupEgress API request.
func (r AuthorizeSecurityGroupEgressRequest) Send(ctx context.Context) (*AuthorizeSecurityGroupEgressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AuthorizeSecurityGroupEgressResponse{
		AuthorizeSecurityGroupEgressOutput: r.Request.Data.(*AuthorizeSecurityGroupEgressOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AuthorizeSecurityGroupEgressResponse is the response type for the
// AuthorizeSecurityGroupEgress API operation.
type AuthorizeSecurityGroupEgressResponse struct {
	*AuthorizeSecurityGroupEgressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AuthorizeSecurityGroupEgress request.
func (r *AuthorizeSecurityGroupEgressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
