// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for DeregisterImage.
type DeregisterImageInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterImageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterImageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterImageInput"}

	if s.ImageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterImageOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterImage = "DeregisterImage"

// DeregisterImageRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deregisters the specified AMI. After you deregister an AMI, it can't be used
// to launch new instances; however, it doesn't affect any instances that you've
// already launched from the AMI. You'll continue to incur usage costs for those
// instances until you terminate them.
//
// When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot
// that was created for the root volume of the instance during the AMI creation
// process. When you deregister an instance store-backed AMI, it doesn't affect
// the files that you uploaded to Amazon S3 when you created the AMI.
//
//    // Example sending a request using DeregisterImageRequest.
//    req := client.DeregisterImageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *Client) DeregisterImageRequest(input *DeregisterImageInput) DeregisterImageRequest {
	op := &aws.Operation{
		Name:       opDeregisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterImageInput{}
	}

	req := c.newRequest(op, input, &DeregisterImageOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeregisterImageRequest{Request: req, Input: input, Copy: c.DeregisterImageRequest}
}

// DeregisterImageRequest is the request type for the
// DeregisterImage API operation.
type DeregisterImageRequest struct {
	*aws.Request
	Input *DeregisterImageInput
	Copy  func(*DeregisterImageInput) DeregisterImageRequest
}

// Send marshals and sends the DeregisterImage API request.
func (r DeregisterImageRequest) Send(ctx context.Context) (*DeregisterImageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterImageResponse{
		DeregisterImageOutput: r.Request.Data.(*DeregisterImageOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterImageResponse is the response type for the
// DeregisterImage API operation.
type DeregisterImageResponse struct {
	*DeregisterImageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterImage request.
func (r *DeregisterImageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
