// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInstanceTypeOfferingsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. Filter names and values are case-sensitive.
	//
	//    * location - This depends on the location type. For example, if the location
	//    type is region (default), the location is the Region code (for example,
	//    us-east-2.)
	//
	//    * instance-type - The instance type.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The location type.
	LocationType LocationType `type:"string" enum:"true"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the next
	// token value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceTypeOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceTypeOfferingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstanceTypeOfferingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeInstanceTypeOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The instance types offered.
	InstanceTypeOfferings []InstanceTypeOffering `locationName:"instanceTypeOfferingSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeInstanceTypeOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstanceTypeOfferings = "DescribeInstanceTypeOfferings"

// DescribeInstanceTypeOfferingsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Returns a list of all instance types offered. The results can be filtered
// by location (Region or Availability Zone). If no location is specified, the
// instance types offered in the current Region are returned.
//
//    // Example sending a request using DescribeInstanceTypeOfferingsRequest.
//    req := client.DescribeInstanceTypeOfferingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings
func (c *Client) DescribeInstanceTypeOfferingsRequest(input *DescribeInstanceTypeOfferingsInput) DescribeInstanceTypeOfferingsRequest {
	op := &aws.Operation{
		Name:       opDescribeInstanceTypeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceTypeOfferingsInput{}
	}

	req := c.newRequest(op, input, &DescribeInstanceTypeOfferingsOutput{})
	return DescribeInstanceTypeOfferingsRequest{Request: req, Input: input, Copy: c.DescribeInstanceTypeOfferingsRequest}
}

// DescribeInstanceTypeOfferingsRequest is the request type for the
// DescribeInstanceTypeOfferings API operation.
type DescribeInstanceTypeOfferingsRequest struct {
	*aws.Request
	Input *DescribeInstanceTypeOfferingsInput
	Copy  func(*DescribeInstanceTypeOfferingsInput) DescribeInstanceTypeOfferingsRequest
}

// Send marshals and sends the DescribeInstanceTypeOfferings API request.
func (r DescribeInstanceTypeOfferingsRequest) Send(ctx context.Context) (*DescribeInstanceTypeOfferingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstanceTypeOfferingsResponse{
		DescribeInstanceTypeOfferingsOutput: r.Request.Data.(*DescribeInstanceTypeOfferingsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInstanceTypeOfferingsResponse is the response type for the
// DescribeInstanceTypeOfferings API operation.
type DescribeInstanceTypeOfferingsResponse struct {
	*DescribeInstanceTypeOfferingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstanceTypeOfferings request.
func (r *DescribeInstanceTypeOfferingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
