// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocalGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The IDs of the local gateways.
	LocalGatewayIds []string `locationName:"LocalGatewayId" locationNameList:"item" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocalGatewaysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocalGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLocalGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about the local gateways.
	LocalGateways []LocalGateway `locationName:"localGatewaySet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocalGateways = "DescribeLocalGateways"

// DescribeLocalGatewaysRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more local gateways. By default, all local gateways are
// described. Alternatively, you can filter the results.
//
//    // Example sending a request using DescribeLocalGatewaysRequest.
//    req := client.DescribeLocalGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways
func (c *Client) DescribeLocalGatewaysRequest(input *DescribeLocalGatewaysInput) DescribeLocalGatewaysRequest {
	op := &aws.Operation{
		Name:       opDescribeLocalGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocalGatewaysInput{}
	}

	req := c.newRequest(op, input, &DescribeLocalGatewaysOutput{})
	return DescribeLocalGatewaysRequest{Request: req, Input: input, Copy: c.DescribeLocalGatewaysRequest}
}

// DescribeLocalGatewaysRequest is the request type for the
// DescribeLocalGateways API operation.
type DescribeLocalGatewaysRequest struct {
	*aws.Request
	Input *DescribeLocalGatewaysInput
	Copy  func(*DescribeLocalGatewaysInput) DescribeLocalGatewaysRequest
}

// Send marshals and sends the DescribeLocalGateways API request.
func (r DescribeLocalGatewaysRequest) Send(ctx context.Context) (*DescribeLocalGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocalGatewaysResponse{
		DescribeLocalGatewaysOutput: r.Request.Data.(*DescribeLocalGatewaysOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLocalGatewaysResponse is the response type for the
// DescribeLocalGateways API operation.
type DescribeLocalGatewaysResponse struct {
	*DescribeLocalGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocalGateways request.
func (r *DescribeLocalGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
