// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A unique name for the key pair.
	//
	// KeyName is a required field
	KeyName *string `locationName:"keyName" type:"string" required:"true"`

	// The public key. For API calls, the text must be base64-encoded. For command
	// line tools, base64 encoding is performed for you.
	//
	// PublicKeyMaterial is automatically base64 encoded/decoded by the SDK.
	//
	// PublicKeyMaterial is a required field
	PublicKeyMaterial []byte `locationName:"publicKeyMaterial" type:"blob" required:"true"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportKeyPairInput"}

	if s.KeyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyName"))
	}

	if s.PublicKeyMaterial == nil {
		invalidParams.Add(aws.NewErrParamRequired("PublicKeyMaterial"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The MD5 public key fingerprint as specified in section 4 of RFC 4716.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// The key pair name you provided.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Imports the public key from an RSA key pair that you created with a third-party
// tool. Compare this with CreateKeyPair, in which AWS creates the key pair
// and gives the keys to you (AWS keeps a copy of the public key). With ImportKeyPair,
// you create the key pair and give AWS just the public key. The private key
// is never transferred between you and AWS.
//
// For more information about key pairs, see Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using ImportKeyPairRequest.
//    req := client.ImportKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportKeyPair
func (c *Client) ImportKeyPairRequest(input *ImportKeyPairInput) ImportKeyPairRequest {
	op := &aws.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	req := c.newRequest(op, input, &ImportKeyPairOutput{})
	return ImportKeyPairRequest{Request: req, Input: input, Copy: c.ImportKeyPairRequest}
}

// ImportKeyPairRequest is the request type for the
// ImportKeyPair API operation.
type ImportKeyPairRequest struct {
	*aws.Request
	Input *ImportKeyPairInput
	Copy  func(*ImportKeyPairInput) ImportKeyPairRequest
}

// Send marshals and sends the ImportKeyPair API request.
func (r ImportKeyPairRequest) Send(ctx context.Context) (*ImportKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ImportKeyPairResponse{
		ImportKeyPairOutput: r.Request.Data.(*ImportKeyPairOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ImportKeyPairResponse is the response type for the
// ImportKeyPair API operation.
type ImportKeyPairResponse struct {
	*ImportKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ImportKeyPair request.
func (r *ImportKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
