// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for ConfigureHealthCheck.
type ConfigureHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The configuration information.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigureHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureHealthCheckInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigureHealthCheckInput"}

	if s.HealthCheck == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthCheck"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ConfigureHealthCheck.
type ConfigureHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// The updated health check.
	HealthCheck *HealthCheck `type:"structure"`
}

// String returns the string representation
func (s ConfigureHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

const opConfigureHealthCheck = "ConfigureHealthCheck"

// ConfigureHealthCheckRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Specifies the health check settings to use when evaluating the health state
// of your EC2 instances.
//
// For more information, see Configure Health Checks for Your Load Balancer
// (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using ConfigureHealthCheckRequest.
//    req := client.ConfigureHealthCheckRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ConfigureHealthCheck
func (c *Client) ConfigureHealthCheckRequest(input *ConfigureHealthCheckInput) ConfigureHealthCheckRequest {
	op := &aws.Operation{
		Name:       opConfigureHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfigureHealthCheckInput{}
	}

	req := c.newRequest(op, input, &ConfigureHealthCheckOutput{})
	return ConfigureHealthCheckRequest{Request: req, Input: input, Copy: c.ConfigureHealthCheckRequest}
}

// ConfigureHealthCheckRequest is the request type for the
// ConfigureHealthCheck API operation.
type ConfigureHealthCheckRequest struct {
	*aws.Request
	Input *ConfigureHealthCheckInput
	Copy  func(*ConfigureHealthCheckInput) ConfigureHealthCheckRequest
}

// Send marshals and sends the ConfigureHealthCheck API request.
func (r ConfigureHealthCheckRequest) Send(ctx context.Context) (*ConfigureHealthCheckResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ConfigureHealthCheckResponse{
		ConfigureHealthCheckOutput: r.Request.Data.(*ConfigureHealthCheckOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ConfigureHealthCheckResponse is the response type for the
// ConfigureHealthCheck API operation.
type ConfigureHealthCheckResponse struct {
	*ConfigureHealthCheckOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ConfigureHealthCheck request.
func (r *ConfigureHealthCheckResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
