// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package firehoseiface provides an interface to enable mocking the Amazon Kinesis Firehose service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package firehoseiface

import (
	"github.com/aws/aws-sdk-go-v2/service/firehose"
)

// ClientAPI provides an interface to enable mocking the
// firehose.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Firehose.
//    func myFunc(svc firehoseiface.ClientAPI) bool {
//        // Make svc.CreateDeliveryStream request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := firehose.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        firehoseiface.ClientPI
//    }
//    func (m *mockClientClient) CreateDeliveryStream(input *firehose.CreateDeliveryStreamInput) (*firehose.CreateDeliveryStreamOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateDeliveryStreamRequest(*firehose.CreateDeliveryStreamInput) firehose.CreateDeliveryStreamRequest

	DeleteDeliveryStreamRequest(*firehose.DeleteDeliveryStreamInput) firehose.DeleteDeliveryStreamRequest

	DescribeDeliveryStreamRequest(*firehose.DescribeDeliveryStreamInput) firehose.DescribeDeliveryStreamRequest

	ListDeliveryStreamsRequest(*firehose.ListDeliveryStreamsInput) firehose.ListDeliveryStreamsRequest

	ListTagsForDeliveryStreamRequest(*firehose.ListTagsForDeliveryStreamInput) firehose.ListTagsForDeliveryStreamRequest

	PutRecordRequest(*firehose.PutRecordInput) firehose.PutRecordRequest

	PutRecordBatchRequest(*firehose.PutRecordBatchInput) firehose.PutRecordBatchRequest

	StartDeliveryStreamEncryptionRequest(*firehose.StartDeliveryStreamEncryptionInput) firehose.StartDeliveryStreamEncryptionRequest

	StopDeliveryStreamEncryptionRequest(*firehose.StopDeliveryStreamEncryptionInput) firehose.StopDeliveryStreamEncryptionRequest

	TagDeliveryStreamRequest(*firehose.TagDeliveryStreamInput) firehose.TagDeliveryStreamRequest

	UntagDeliveryStreamRequest(*firehose.UntagDeliveryStreamInput) firehose.UntagDeliveryStreamRequest

	UpdateDestinationRequest(*firehose.UpdateDestinationInput) firehose.UpdateDestinationRequest
}

var _ ClientAPI = (*firehose.Client)(nil)
