// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the connection. If none is
	// provided, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A ConnectionInput object defining the connection to create.
	//
	// ConnectionInput is a required field
	ConnectionInput *ConnectionInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ConnectionInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionInput"))
	}
	if s.ConnectionInput != nil {
		if err := s.ConnectionInput.Validate(); err != nil {
			invalidParams.AddNested("ConnectionInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates a connection definition in the Data Catalog.
//
//    // Example sending a request using CreateConnectionRequest.
//    req := client.CreateConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection
func (c *Client) CreateConnectionRequest(input *CreateConnectionInput) CreateConnectionRequest {
	op := &aws.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	req := c.newRequest(op, input, &CreateConnectionOutput{})
	return CreateConnectionRequest{Request: req, Input: input, Copy: c.CreateConnectionRequest}
}

// CreateConnectionRequest is the request type for the
// CreateConnection API operation.
type CreateConnectionRequest struct {
	*aws.Request
	Input *CreateConnectionInput
	Copy  func(*CreateConnectionInput) CreateConnectionRequest
}

// Send marshals and sends the CreateConnection API request.
func (r CreateConnectionRequest) Send(ctx context.Context) (*CreateConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConnectionResponse{
		CreateConnectionOutput: r.Request.Data.(*CreateConnectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConnectionResponse is the response type for the
// CreateConnection API operation.
type CreateConnectionResponse struct {
	*CreateConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConnection request.
func (r *CreateConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
