// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopCrawlerInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to stop.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCrawlerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopCrawlerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopCrawler = "StopCrawler"

// StopCrawlerRequest returns a request value for making API operation for
// AWS Glue.
//
// If the specified crawler is running, stops the crawl.
//
//    // Example sending a request using StopCrawlerRequest.
//    req := client.StopCrawlerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler
func (c *Client) StopCrawlerRequest(input *StopCrawlerInput) StopCrawlerRequest {
	op := &aws.Operation{
		Name:       opStopCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerInput{}
	}

	req := c.newRequest(op, input, &StopCrawlerOutput{})
	return StopCrawlerRequest{Request: req, Input: input, Copy: c.StopCrawlerRequest}
}

// StopCrawlerRequest is the request type for the
// StopCrawler API operation.
type StopCrawlerRequest struct {
	*aws.Request
	Input *StopCrawlerInput
	Copy  func(*StopCrawlerInput) StopCrawlerRequest
}

// Send marshals and sends the StopCrawler API request.
func (r StopCrawlerRequest) Send(ctx context.Context) (*StopCrawlerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopCrawlerResponse{
		StopCrawlerOutput: r.Request.Data.(*StopCrawlerOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopCrawlerResponse is the response type for the
// StopCrawler API operation.
type StopCrawlerResponse struct {
	*StopCrawlerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopCrawler request.
func (r *StopCrawlerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
