// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListLoggerDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggerDefinitionVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLoggerDefinitionVersionsInput"}

	if s.LoggerDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListLoggerDefinitionVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.LoggerDefinitionId != nil {
		v := *s.LoggerDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "LoggerDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListLoggerDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListLoggerDefinitionVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListLoggerDefinitionVersions = "ListLoggerDefinitionVersions"

// ListLoggerDefinitionVersionsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Lists the versions of a logger definition.
//
//    // Example sending a request using ListLoggerDefinitionVersionsRequest.
//    req := client.ListLoggerDefinitionVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions
func (c *Client) ListLoggerDefinitionVersionsRequest(input *ListLoggerDefinitionVersionsInput) ListLoggerDefinitionVersionsRequest {
	op := &aws.Operation{
		Name:       opListLoggerDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
	}

	if input == nil {
		input = &ListLoggerDefinitionVersionsInput{}
	}

	req := c.newRequest(op, input, &ListLoggerDefinitionVersionsOutput{})
	return ListLoggerDefinitionVersionsRequest{Request: req, Input: input, Copy: c.ListLoggerDefinitionVersionsRequest}
}

// ListLoggerDefinitionVersionsRequest is the request type for the
// ListLoggerDefinitionVersions API operation.
type ListLoggerDefinitionVersionsRequest struct {
	*aws.Request
	Input *ListLoggerDefinitionVersionsInput
	Copy  func(*ListLoggerDefinitionVersionsInput) ListLoggerDefinitionVersionsRequest
}

// Send marshals and sends the ListLoggerDefinitionVersions API request.
func (r ListLoggerDefinitionVersionsRequest) Send(ctx context.Context) (*ListLoggerDefinitionVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLoggerDefinitionVersionsResponse{
		ListLoggerDefinitionVersionsOutput: r.Request.Data.(*ListLoggerDefinitionVersionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLoggerDefinitionVersionsResponse is the response type for the
// ListLoggerDefinitionVersions API operation.
type ListLoggerDefinitionVersionsResponse struct {
	*ListLoggerDefinitionVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLoggerDefinitionVersions request.
func (r *ListLoggerDefinitionVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
