// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The name of the IAM user that the new key will belong to.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAccessKeyInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful CreateAccessKey request.
type CreateAccessKeyOutput struct {
	_ struct{} `type:"structure"`

	// A structure with details about the access key.
	//
	// AccessKey is a required field
	AccessKey *AccessKey `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAccessKey = "CreateAccessKey"

// CreateAccessKeyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Creates a new AWS secret access key and corresponding AWS access key ID for
// the specified user. The default status for new keys is Active.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. This operation works
// for access keys under the AWS account. Consequently, you can use this operation
// to manage AWS account root user credentials. This is true even if the AWS
// account has no associated users.
//
// For information about limits on the number of keys you can create, see Limitations
// on IAM Entities (https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation. You must save the key (for example, in
// a text file) if you want to be able to access it again. If a secret key is
// lost, you can delete the access keys for the associated user and then create
// new keys.
//
//    // Example sending a request using CreateAccessKeyRequest.
//    req := client.CreateAccessKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey
func (c *Client) CreateAccessKeyRequest(input *CreateAccessKeyInput) CreateAccessKeyRequest {
	op := &aws.Operation{
		Name:       opCreateAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccessKeyInput{}
	}

	req := c.newRequest(op, input, &CreateAccessKeyOutput{})
	return CreateAccessKeyRequest{Request: req, Input: input, Copy: c.CreateAccessKeyRequest}
}

// CreateAccessKeyRequest is the request type for the
// CreateAccessKey API operation.
type CreateAccessKeyRequest struct {
	*aws.Request
	Input *CreateAccessKeyInput
	Copy  func(*CreateAccessKeyInput) CreateAccessKeyRequest
}

// Send marshals and sends the CreateAccessKey API request.
func (r CreateAccessKeyRequest) Send(ctx context.Context) (*CreateAccessKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAccessKeyResponse{
		CreateAccessKeyOutput: r.Request.Data.(*CreateAccessKeyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAccessKeyResponse is the response type for the
// CreateAccessKey API operation.
type CreateAccessKeyResponse struct {
	*CreateAccessKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAccessKey request.
func (r *CreateAccessKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
