// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAssessmentRunAgentsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run whose agents you want to list.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AgentFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentRunAgents action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentRunAgentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssessmentRunAgentsInput"}

	if s.AssessmentRunArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentRunArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssessmentRunAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the agents returned by the action.
	//
	// AssessmentRunAgents is a required field
	AssessmentRunAgents []AssessmentRunAgent `locationName:"assessmentRunAgents" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssessmentRunAgents = "ListAssessmentRunAgents"

// ListAssessmentRunAgentsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Lists the agents of the assessment runs that are specified by the ARNs of
// the assessment runs.
//
//    // Example sending a request using ListAssessmentRunAgentsRequest.
//    req := client.ListAssessmentRunAgentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents
func (c *Client) ListAssessmentRunAgentsRequest(input *ListAssessmentRunAgentsInput) ListAssessmentRunAgentsRequest {
	op := &aws.Operation{
		Name:       opListAssessmentRunAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentRunAgentsInput{}
	}

	req := c.newRequest(op, input, &ListAssessmentRunAgentsOutput{})
	return ListAssessmentRunAgentsRequest{Request: req, Input: input, Copy: c.ListAssessmentRunAgentsRequest}
}

// ListAssessmentRunAgentsRequest is the request type for the
// ListAssessmentRunAgents API operation.
type ListAssessmentRunAgentsRequest struct {
	*aws.Request
	Input *ListAssessmentRunAgentsInput
	Copy  func(*ListAssessmentRunAgentsInput) ListAssessmentRunAgentsRequest
}

// Send marshals and sends the ListAssessmentRunAgents API request.
func (r ListAssessmentRunAgentsRequest) Send(ctx context.Context) (*ListAssessmentRunAgentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssessmentRunAgentsResponse{
		ListAssessmentRunAgentsOutput: r.Request.Data.(*ListAssessmentRunAgentsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssessmentRunAgentsRequestPaginator returns a paginator for ListAssessmentRunAgents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssessmentRunAgentsRequest(input)
//   p := inspector.NewListAssessmentRunAgentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssessmentRunAgentsPaginator(req ListAssessmentRunAgentsRequest) ListAssessmentRunAgentsPaginator {
	return ListAssessmentRunAgentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssessmentRunAgentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssessmentRunAgentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssessmentRunAgentsPaginator struct {
	aws.Pager
}

func (p *ListAssessmentRunAgentsPaginator) CurrentPage() *ListAssessmentRunAgentsOutput {
	return p.Pager.CurrentPage().(*ListAssessmentRunAgentsOutput)
}

// ListAssessmentRunAgentsResponse is the response type for the
// ListAssessmentRunAgents API operation.
type ListAssessmentRunAgentsResponse struct {
	*ListAssessmentRunAgentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssessmentRunAgents request.
func (r *ListAssessmentRunAgentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
