// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input for DecreaseStreamRetentionPeriod.
type DecreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be less than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `min:"1" type:"integer" required:"true"`

	// The name of the stream to modify.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DecreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecreaseStreamRetentionPeriodInput"}

	if s.RetentionPeriodHours == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.RetentionPeriodHours != nil && *s.RetentionPeriodHours < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RetentionPeriodHours", 1))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DecreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DecreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

const opDecreaseStreamRetentionPeriod = "DecreaseStreamRetentionPeriod"

// DecreaseStreamRetentionPeriodRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Decreases the Kinesis data stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// minimum value of a stream's retention period is 24 hours.
//
// This operation may result in lost data. For example, if the stream's retention
// period is 48 hours and is decreased to 24 hours, any data already in the
// stream that is older than 24 hours is inaccessible.
//
//    // Example sending a request using DecreaseStreamRetentionPeriodRequest.
//    req := client.DecreaseStreamRetentionPeriodRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod
func (c *Client) DecreaseStreamRetentionPeriodRequest(input *DecreaseStreamRetentionPeriodInput) DecreaseStreamRetentionPeriodRequest {
	op := &aws.Operation{
		Name:       opDecreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseStreamRetentionPeriodInput{}
	}

	req := c.newRequest(op, input, &DecreaseStreamRetentionPeriodOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DecreaseStreamRetentionPeriodRequest{Request: req, Input: input, Copy: c.DecreaseStreamRetentionPeriodRequest}
}

// DecreaseStreamRetentionPeriodRequest is the request type for the
// DecreaseStreamRetentionPeriod API operation.
type DecreaseStreamRetentionPeriodRequest struct {
	*aws.Request
	Input *DecreaseStreamRetentionPeriodInput
	Copy  func(*DecreaseStreamRetentionPeriodInput) DecreaseStreamRetentionPeriodRequest
}

// Send marshals and sends the DecreaseStreamRetentionPeriod API request.
func (r DecreaseStreamRetentionPeriodRequest) Send(ctx context.Context) (*DecreaseStreamRetentionPeriodResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DecreaseStreamRetentionPeriodResponse{
		DecreaseStreamRetentionPeriodOutput: r.Request.Data.(*DecreaseStreamRetentionPeriodOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DecreaseStreamRetentionPeriodResponse is the response type for the
// DecreaseStreamRetentionPeriod API operation.
type DecreaseStreamRetentionPeriodResponse struct {
	*DecreaseStreamRetentionPeriodOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DecreaseStreamRetentionPeriod request.
func (r *DecreaseStreamRetentionPeriodResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
