// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Name of the application to start the list with. When using pagination to
	// retrieve the list, you don't need to specify this parameter in the first
	// request. However, in subsequent requests, you add the last application name
	// from the previous response to get the next page of applications.
	ExclusiveStartApplicationName *string `min:"1" type:"string"`

	// Maximum number of applications to list.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.ExclusiveStartApplicationName != nil && len(*s.ExclusiveStartApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusiveStartApplicationName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// List of ApplicationSummary objects.
	//
	// ApplicationSummaries is a required field
	ApplicationSummaries []ApplicationSummary `type:"list" required:"true"`

	// Returns true if there are more applications to retrieve.
	//
	// HasMoreApplications is a required field
	HasMoreApplications *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListApplications = "ListApplications"

// ListApplicationsRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Returns a list of Amazon Kinesis Analytics applications in your account.
// For each application, the response includes the application name, Amazon
// Resource Name (ARN), and status. If the response returns the HasMoreApplications
// value as true, you can send another request by adding the ExclusiveStartApplicationName
// in the request body, and set the value of this to the last application name
// from the previous response.
//
// If you want detailed information about a specific application, use DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html).
//
// This operation requires permissions to perform the kinesisanalytics:ListApplications
// action.
//
//    // Example sending a request using ListApplicationsRequest.
//    req := client.ListApplicationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ListApplications
func (c *Client) ListApplicationsRequest(input *ListApplicationsInput) ListApplicationsRequest {
	op := &aws.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	req := c.newRequest(op, input, &ListApplicationsOutput{})
	return ListApplicationsRequest{Request: req, Input: input, Copy: c.ListApplicationsRequest}
}

// ListApplicationsRequest is the request type for the
// ListApplications API operation.
type ListApplicationsRequest struct {
	*aws.Request
	Input *ListApplicationsInput
	Copy  func(*ListApplicationsInput) ListApplicationsRequest
}

// Send marshals and sends the ListApplications API request.
func (r ListApplicationsRequest) Send(ctx context.Context) (*ListApplicationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListApplicationsResponse{
		ListApplicationsOutput: r.Request.Data.(*ListApplicationsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListApplicationsResponse is the response type for the
// ListApplications API operation.
type ListApplicationsResponse struct {
	*ListApplicationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListApplications request.
func (r *ListApplicationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
