// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// Describes the specified customer master key (CMK).
	//
	// If you specify a predefined AWS alias (an AWS alias with no key ID), KMS
	// associates the alias with an AWS managed CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
	// and returns its KeyId and Arn in the response.
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeKeyInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Provides detailed information about a customer master key (CMK). You can
// run DescribeKey on a customer managed CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)
// or an AWS managed CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
//
// This detailed information includes the key ARN, creation date (and deletion
// date, if applicable), the key state, and the origin and expiration date (if
// any) of the key material. For CMKs in custom key stores, it includes information
// about the custom key store, such as the key store ID and the AWS CloudHSM
// cluster ID. It includes fields, like KeySpec, that help you distinguish symmetric
// from asymmetric CMKs. It also provides information that is particularly important
// to asymmetric CMKs, such as the key usage (encryption or signing) and the
// encryption algorithms or signing algorithms that the CMK supports.
//
// DescribeKey does not return the following information:
//
//    * Aliases associated with the CMK. To get this information, use ListAliases.
//
//    * Whether automatic key rotation is enabled on the CMK. To get this information,
//    use GetKeyRotationStatus. Also, some key states prevent a CMK from being
//    automatically rotated. For details, see How Automatic Key Rotation Works
//    (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works)
//    in AWS Key Management Service Developer Guide.
//
//    * Tags on the CMK. To get this information, use ListResourceTags.
//
//    * Key policies and grants on the CMK. To get this information, use GetKeyPolicy
//    and ListGrants.
//
// If you call the DescribeKey operation on a predefined AWS alias, that is,
// an AWS alias with no key ID, AWS KMS creates an AWS managed CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
// Then, it associates the alias with the new CMK, and returns the KeyId and
// Arn of the new CMK in the response.
//
// To perform this operation on a CMK in a different AWS account, specify the
// key ARN or alias ARN in the value of the KeyId parameter.
//
//    // Example sending a request using DescribeKeyRequest.
//    req := client.DescribeKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKey
func (c *Client) DescribeKeyRequest(input *DescribeKeyInput) DescribeKeyRequest {
	op := &aws.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	req := c.newRequest(op, input, &DescribeKeyOutput{})
	return DescribeKeyRequest{Request: req, Input: input, Copy: c.DescribeKeyRequest}
}

// DescribeKeyRequest is the request type for the
// DescribeKey API operation.
type DescribeKeyRequest struct {
	*aws.Request
	Input *DescribeKeyInput
	Copy  func(*DescribeKeyInput) DescribeKeyRequest
}

// Send marshals and sends the DescribeKey API request.
func (r DescribeKeyRequest) Send(ctx context.Context) (*DescribeKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeKeyResponse{
		DescribeKeyOutput: r.Request.Data.(*DescribeKeyOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeKeyResponse is the response type for the
// DescribeKey API operation.
type DescribeKeyResponse struct {
	*DescribeKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeKey request.
func (r *DescribeKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
