// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lakeformationiface provides an interface to enable mocking the AWS Lake Formation service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lakeformationiface

import (
	"github.com/aws/aws-sdk-go-v2/service/lakeformation"
)

// ClientAPI provides an interface to enable mocking the
// lakeformation.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Lake Formation.
//    func myFunc(svc lakeformationiface.ClientAPI) bool {
//        // Make svc.BatchGrantPermissions request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := lakeformation.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        lakeformationiface.ClientPI
//    }
//    func (m *mockClientClient) BatchGrantPermissions(input *lakeformation.BatchGrantPermissionsInput) (*lakeformation.BatchGrantPermissionsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchGrantPermissionsRequest(*lakeformation.BatchGrantPermissionsInput) lakeformation.BatchGrantPermissionsRequest

	BatchRevokePermissionsRequest(*lakeformation.BatchRevokePermissionsInput) lakeformation.BatchRevokePermissionsRequest

	DeregisterResourceRequest(*lakeformation.DeregisterResourceInput) lakeformation.DeregisterResourceRequest

	DescribeResourceRequest(*lakeformation.DescribeResourceInput) lakeformation.DescribeResourceRequest

	GetDataLakeSettingsRequest(*lakeformation.GetDataLakeSettingsInput) lakeformation.GetDataLakeSettingsRequest

	GetEffectivePermissionsForPathRequest(*lakeformation.GetEffectivePermissionsForPathInput) lakeformation.GetEffectivePermissionsForPathRequest

	GrantPermissionsRequest(*lakeformation.GrantPermissionsInput) lakeformation.GrantPermissionsRequest

	ListPermissionsRequest(*lakeformation.ListPermissionsInput) lakeformation.ListPermissionsRequest

	ListResourcesRequest(*lakeformation.ListResourcesInput) lakeformation.ListResourcesRequest

	PutDataLakeSettingsRequest(*lakeformation.PutDataLakeSettingsInput) lakeformation.PutDataLakeSettingsRequest

	RegisterResourceRequest(*lakeformation.RegisterResourceInput) lakeformation.RegisterResourceRequest

	RevokePermissionsRequest(*lakeformation.RevokePermissionsInput) lakeformation.RevokePermissionsRequest

	UpdateResourceRequest(*lakeformation.UpdateResourceInput) lakeformation.UpdateResourceRequest
}

var _ ClientAPI = (*lakeformation.Client)(nil)
