// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListFailuresForLicenseConfigurationOperationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFailuresForLicenseConfigurationOperationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFailuresForLicenseConfigurationOperationsInput"}

	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListFailuresForLicenseConfigurationOperationsOutput struct {
	_ struct{} `type:"structure"`

	// License configuration operations that failed.
	LicenseOperationFailureList []LicenseOperationFailure `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListFailuresForLicenseConfigurationOperations = "ListFailuresForLicenseConfigurationOperations"

// ListFailuresForLicenseConfigurationOperationsRequest returns a request value for making API operation for
// AWS License Manager.
//
// Lists the license configuration operations that failed.
//
//    // Example sending a request using ListFailuresForLicenseConfigurationOperationsRequest.
//    req := client.ListFailuresForLicenseConfigurationOperationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations
func (c *Client) ListFailuresForLicenseConfigurationOperationsRequest(input *ListFailuresForLicenseConfigurationOperationsInput) ListFailuresForLicenseConfigurationOperationsRequest {
	op := &aws.Operation{
		Name:       opListFailuresForLicenseConfigurationOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFailuresForLicenseConfigurationOperationsInput{}
	}

	req := c.newRequest(op, input, &ListFailuresForLicenseConfigurationOperationsOutput{})
	return ListFailuresForLicenseConfigurationOperationsRequest{Request: req, Input: input, Copy: c.ListFailuresForLicenseConfigurationOperationsRequest}
}

// ListFailuresForLicenseConfigurationOperationsRequest is the request type for the
// ListFailuresForLicenseConfigurationOperations API operation.
type ListFailuresForLicenseConfigurationOperationsRequest struct {
	*aws.Request
	Input *ListFailuresForLicenseConfigurationOperationsInput
	Copy  func(*ListFailuresForLicenseConfigurationOperationsInput) ListFailuresForLicenseConfigurationOperationsRequest
}

// Send marshals and sends the ListFailuresForLicenseConfigurationOperations API request.
func (r ListFailuresForLicenseConfigurationOperationsRequest) Send(ctx context.Context) (*ListFailuresForLicenseConfigurationOperationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFailuresForLicenseConfigurationOperationsResponse{
		ListFailuresForLicenseConfigurationOperationsOutput: r.Request.Data.(*ListFailuresForLicenseConfigurationOperationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListFailuresForLicenseConfigurationOperationsResponse is the response type for the
// ListFailuresForLicenseConfigurationOperations API operation.
type ListFailuresForLicenseConfigurationOperationsResponse struct {
	*ListFailuresForLicenseConfigurationOperationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFailuresForLicenseConfigurationOperations request.
func (r *ListFailuresForLicenseConfigurationOperationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
