// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconvert

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Delete a preset by sending a request with the preset name
type DeletePresetInput struct {
	_ struct{} `type:"structure"`

	// The name of the preset to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePresetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePresetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePresetInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePresetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Delete preset requests will return an OK message or error message with an
// empty body.
type DeletePresetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePresetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePresetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePreset = "DeletePreset"

// DeletePresetRequest returns a request value for making API operation for
// AWS Elemental MediaConvert.
//
// Permanently delete a preset you have created.
//
//    // Example sending a request using DeletePresetRequest.
//    req := client.DeletePresetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePreset
func (c *Client) DeletePresetRequest(input *DeletePresetInput) DeletePresetRequest {
	op := &aws.Operation{
		Name:       opDeletePreset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-08-29/presets/{name}",
	}

	if input == nil {
		input = &DeletePresetInput{}
	}

	req := c.newRequest(op, input, &DeletePresetOutput{})
	return DeletePresetRequest{Request: req, Input: input, Copy: c.DeletePresetRequest}
}

// DeletePresetRequest is the request type for the
// DeletePreset API operation.
type DeletePresetRequest struct {
	*aws.Request
	Input *DeletePresetInput
	Copy  func(*DeletePresetInput) DeletePresetRequest
}

// Send marshals and sends the DeletePreset API request.
func (r DeletePresetRequest) Send(ctx context.Context) (*DeletePresetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePresetResponse{
		DeletePresetOutput: r.Request.Data.(*DeletePresetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePresetResponse is the response type for the
// DeletePreset API operation.
type DeletePresetResponse struct {
	*DeletePresetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePreset request.
func (r *DeletePresetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
