// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiplexProgramInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMultiplexProgramInput"}

	if s.MultiplexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MultiplexId"))
	}

	if s.ProgramName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProgramName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMultiplexProgramInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MultiplexId != nil {
		v := *s.MultiplexId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "multiplexId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgramName != nil {
		v := *s.ProgramName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "programName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// Packet identifiers map for a given Multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation
func (s DeleteMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMultiplexProgramOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultiplexProgramSettings != nil {
		v := s.MultiplexProgramSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexProgramSettings", v, metadata)
	}
	if s.PacketIdentifiersMap != nil {
		v := s.PacketIdentifiersMap

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "packetIdentifiersMap", v, metadata)
	}
	if s.ProgramName != nil {
		v := *s.ProgramName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteMultiplexProgram = "DeleteMultiplexProgram"

// DeleteMultiplexProgramRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Delete a program from a multiplex.
//
//    // Example sending a request using DeleteMultiplexProgramRequest.
//    req := client.DeleteMultiplexProgramRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram
func (c *Client) DeleteMultiplexProgramRequest(input *DeleteMultiplexProgramInput) DeleteMultiplexProgramRequest {
	op := &aws.Operation{
		Name:       opDeleteMultiplexProgram,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &DeleteMultiplexProgramInput{}
	}

	req := c.newRequest(op, input, &DeleteMultiplexProgramOutput{})
	return DeleteMultiplexProgramRequest{Request: req, Input: input, Copy: c.DeleteMultiplexProgramRequest}
}

// DeleteMultiplexProgramRequest is the request type for the
// DeleteMultiplexProgram API operation.
type DeleteMultiplexProgramRequest struct {
	*aws.Request
	Input *DeleteMultiplexProgramInput
	Copy  func(*DeleteMultiplexProgramInput) DeleteMultiplexProgramRequest
}

// Send marshals and sends the DeleteMultiplexProgram API request.
func (r DeleteMultiplexProgramRequest) Send(ctx context.Context) (*DeleteMultiplexProgramResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMultiplexProgramResponse{
		DeleteMultiplexProgramOutput: r.Request.Data.(*DeleteMultiplexProgramOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMultiplexProgramResponse is the response type for the
// DeleteMultiplexProgram API operation.
type DeleteMultiplexProgramResponse struct {
	*DeleteMultiplexProgramOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMultiplexProgram request.
func (r *DeleteMultiplexProgramResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
