// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeGlobalNetworksInput struct {
	_ struct{} `type:"structure"`

	// The IDs of one or more global networks. The maximum is 10.
	GlobalNetworkIds []string `location:"querystring" locationName:"globalNetworkIds" type:"list"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeGlobalNetworksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGlobalNetworksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGlobalNetworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeGlobalNetworksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkIds != nil {
		v := s.GlobalNetworkIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "globalNetworkIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeGlobalNetworksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the global networks.
	GlobalNetworks []GlobalNetwork `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeGlobalNetworksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeGlobalNetworksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GlobalNetworks != nil {
		v := s.GlobalNetworks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GlobalNetworks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeGlobalNetworks = "DescribeGlobalNetworks"

// DescribeGlobalNetworksRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Describes one or more global networks. By default, all global networks are
// described. To describe the objects in your global network, you must use the
// appropriate Get* action. For example, to list the transit gateways in your
// global network, use GetTransitGatewayRegistrations.
//
//    // Example sending a request using DescribeGlobalNetworksRequest.
//    req := client.DescribeGlobalNetworksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks
func (c *Client) DescribeGlobalNetworksRequest(input *DescribeGlobalNetworksInput) DescribeGlobalNetworksRequest {
	op := &aws.Operation{
		Name:       opDescribeGlobalNetworks,
		HTTPMethod: "GET",
		HTTPPath:   "/global-networks",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGlobalNetworksInput{}
	}

	req := c.newRequest(op, input, &DescribeGlobalNetworksOutput{})
	return DescribeGlobalNetworksRequest{Request: req, Input: input, Copy: c.DescribeGlobalNetworksRequest}
}

// DescribeGlobalNetworksRequest is the request type for the
// DescribeGlobalNetworks API operation.
type DescribeGlobalNetworksRequest struct {
	*aws.Request
	Input *DescribeGlobalNetworksInput
	Copy  func(*DescribeGlobalNetworksInput) DescribeGlobalNetworksRequest
}

// Send marshals and sends the DescribeGlobalNetworks API request.
func (r DescribeGlobalNetworksRequest) Send(ctx context.Context) (*DescribeGlobalNetworksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGlobalNetworksResponse{
		DescribeGlobalNetworksOutput: r.Request.Data.(*DescribeGlobalNetworksOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeGlobalNetworksRequestPaginator returns a paginator for DescribeGlobalNetworks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeGlobalNetworksRequest(input)
//   p := networkmanager.NewDescribeGlobalNetworksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeGlobalNetworksPaginator(req DescribeGlobalNetworksRequest) DescribeGlobalNetworksPaginator {
	return DescribeGlobalNetworksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeGlobalNetworksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeGlobalNetworksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeGlobalNetworksPaginator struct {
	aws.Pager
}

func (p *DescribeGlobalNetworksPaginator) CurrentPage() *DescribeGlobalNetworksOutput {
	return p.Pager.CurrentPage().(*DescribeGlobalNetworksOutput)
}

// DescribeGlobalNetworksResponse is the response type for the
// DescribeGlobalNetworks API operation.
type DescribeGlobalNetworksResponse struct {
	*DescribeGlobalNetworksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGlobalNetworks request.
func (r *DescribeGlobalNetworksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
