// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCustomerGatewayAssociationsInput struct {
	_ struct{} `type:"structure"`

	// One or more customer gateway Amazon Resource Names (ARNs). For more information,
	// see Resources Defined by Amazon EC2 (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies).
	// The maximum is 10.
	CustomerGatewayArns []string `location:"querystring" locationName:"customerGatewayArns" type:"list"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetCustomerGatewayAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomerGatewayAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCustomerGatewayAssociationsInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCustomerGatewayAssociationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CustomerGatewayArns != nil {
		v := s.CustomerGatewayArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "customerGatewayArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetCustomerGatewayAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The customer gateway associations.
	CustomerGatewayAssociations []CustomerGatewayAssociation `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCustomerGatewayAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCustomerGatewayAssociationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerGatewayAssociations != nil {
		v := s.CustomerGatewayAssociations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CustomerGatewayAssociations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetCustomerGatewayAssociations = "GetCustomerGatewayAssociations"

// GetCustomerGatewayAssociationsRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Gets the association information for customer gateways that are associated
// with devices and links in your global network.
//
//    // Example sending a request using GetCustomerGatewayAssociationsRequest.
//    req := client.GetCustomerGatewayAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations
func (c *Client) GetCustomerGatewayAssociationsRequest(input *GetCustomerGatewayAssociationsInput) GetCustomerGatewayAssociationsRequest {
	op := &aws.Operation{
		Name:       opGetCustomerGatewayAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/global-networks/{globalNetworkId}/customer-gateway-associations",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCustomerGatewayAssociationsInput{}
	}

	req := c.newRequest(op, input, &GetCustomerGatewayAssociationsOutput{})
	return GetCustomerGatewayAssociationsRequest{Request: req, Input: input, Copy: c.GetCustomerGatewayAssociationsRequest}
}

// GetCustomerGatewayAssociationsRequest is the request type for the
// GetCustomerGatewayAssociations API operation.
type GetCustomerGatewayAssociationsRequest struct {
	*aws.Request
	Input *GetCustomerGatewayAssociationsInput
	Copy  func(*GetCustomerGatewayAssociationsInput) GetCustomerGatewayAssociationsRequest
}

// Send marshals and sends the GetCustomerGatewayAssociations API request.
func (r GetCustomerGatewayAssociationsRequest) Send(ctx context.Context) (*GetCustomerGatewayAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCustomerGatewayAssociationsResponse{
		GetCustomerGatewayAssociationsOutput: r.Request.Data.(*GetCustomerGatewayAssociationsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetCustomerGatewayAssociationsRequestPaginator returns a paginator for GetCustomerGatewayAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetCustomerGatewayAssociationsRequest(input)
//   p := networkmanager.NewGetCustomerGatewayAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetCustomerGatewayAssociationsPaginator(req GetCustomerGatewayAssociationsRequest) GetCustomerGatewayAssociationsPaginator {
	return GetCustomerGatewayAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetCustomerGatewayAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetCustomerGatewayAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetCustomerGatewayAssociationsPaginator struct {
	aws.Pager
}

func (p *GetCustomerGatewayAssociationsPaginator) CurrentPage() *GetCustomerGatewayAssociationsOutput {
	return p.Pager.CurrentPage().(*GetCustomerGatewayAssociationsOutput)
}

// GetCustomerGatewayAssociationsResponse is the response type for the
// GetCustomerGatewayAssociations API operation.
type GetCustomerGatewayAssociationsResponse struct {
	*GetCustomerGatewayAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCustomerGatewayAssociations request.
func (r *GetCustomerGatewayAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
